/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.domain.SearchResult;
import org.springframework.data.domain.SearchResults;
import org.springframework.data.geo.GeoPage;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.data.neo4j.repository.query.VectorSearch;
import org.springframework.data.neo4j.repository.support.CypherdslStatementExecutor;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class Neo4jQueryMethod
extends QueryMethod {
    static final List<Class<? extends Serializable>> GEO_NEAR_RESULTS = List.of(GeoResult.class, GeoResults.class, GeoPage.class);
    static final List<Class<? extends Serializable>> VECTOR_SEARCH_RESULTS = List.of(SearchResults.class, SearchResult.class);
    private final @Nullable Query queryAnnotation;
    private final @Nullable VectorSearch vectorSearchAnnotation;
    private final String repositoryName;
    private final boolean cypherBasedProjection;
    private final Method method;

    Neo4jQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        this(method, metadata, factory, ClassUtils.hasMethod(CypherdslStatementExecutor.class, (Method)method));
    }

    Neo4jQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, boolean cypherBasedProjection) {
        super(method, metadata, factory, Neo4jParameters::new);
        this.method = method;
        this.repositoryName = this.method.getDeclaringClass().getName();
        this.cypherBasedProjection = cypherBasedProjection;
        this.queryAnnotation = (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, Query.class);
        this.vectorSearchAnnotation = (VectorSearch)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, VectorSearch.class);
    }

    String getRepositoryName() {
        return this.repositoryName;
    }

    boolean isCollectionLikeQuery() {
        return this.isCollectionQuery() || this.isStreamQuery();
    }

    boolean isCypherBasedProjection() {
        return this.cypherBasedProjection;
    }

    boolean hasQueryAnnotation() {
        return this.queryAnnotation != null;
    }

    Optional<Query> getQueryAnnotation() {
        return Optional.ofNullable(this.queryAnnotation);
    }

    boolean hasVectorSearchAnnotation() {
        return this.vectorSearchAnnotation != null;
    }

    Optional<VectorSearch> getVectorSearchAnnotation() {
        return Optional.ofNullable(this.vectorSearchAnnotation);
    }

    public Class<?> getReturnedObjectType() {
        Class returnedObjectType = super.getReturnedObjectType();
        if (returnedObjectType.equals(GeoResult.class)) {
            return this.getDomainClass();
        }
        return returnedObjectType;
    }

    boolean incrementLimit() {
        return this.isSliceQuery() && this.getQueryAnnotation().map(Query::countQuery).filter(StringUtils::hasText).isEmpty() || this.isScrollQuery();
    }

    boolean asCollectionQuery() {
        return this.isCollectionLikeQuery() || this.isPageQuery() || this.isSliceQuery() || this.isScrollQuery() || GeoResults.class.isAssignableFrom(this.method.getReturnType()) || this.isSearchQuery();
    }

    Method getMethod() {
        return this.method;
    }

    static class Neo4jParameter
    extends Parameter {
        private static final String NAMED_PARAMETER_TEMPLATE = "$%s";
        private static final String POSITION_PARAMETER_TEMPLATE = "$%d";

        Neo4jParameter(MethodParameter parameter, TypeInformation<?> domainType) {
            super(parameter, domainType);
        }

        public String getPlaceholder() {
            if (this.isNamedParameter()) {
                return String.format(NAMED_PARAMETER_TEMPLATE, this.getName().orElseThrow());
            }
            return String.format(POSITION_PARAMETER_TEMPLATE, this.getIndex());
        }
    }

    static class Neo4jParameters
    extends Parameters<Neo4jParameters, Neo4jParameter> {
        Neo4jParameters(ParametersSource parametersSource) {
            super(parametersSource, it -> new Neo4jParameter((MethodParameter)it, (TypeInformation<?>)parametersSource.getDomainTypeInformation()));
        }

        private Neo4jParameters(List<Neo4jParameter> originals) {
            super(originals);
        }

        protected Neo4jParameters createFrom(List<Neo4jParameter> parameters) {
            return new Neo4jParameters(parameters);
        }
    }
}

