/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collection;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.driver.Record;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.neo4j.core.KRecordFetchSpec;
import org.springframework.data.neo4j.core.Neo4jClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\nJ\r\u0010\r\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000eJ\u000b\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/springframework/data/neo4j/core/KMappingSpec;", "T", "", "delegate", "Lorg/springframework/data/neo4j/core/Neo4jClient$MappingSpec;", "<init>", "(Lorg/springframework/data/neo4j/core/Neo4jClient$MappingSpec;)V", "mappedBy", "Lorg/springframework/data/neo4j/core/KRecordFetchSpec;", "mappingFunction", "Ljava/util/function/BiFunction;", "Lorg/neo4j/driver/types/TypeSystem;", "Lorg/neo4j/driver/Record;", "one", "()Ljava/lang/Object;", "first", "all", "", "spring-data-neo4j"})
public final class KMappingSpec<T> {
    @NotNull
    private final Neo4jClient.MappingSpec<T> delegate;

    public KMappingSpec(@NotNull Neo4jClient.MappingSpec<T> delegate) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @NotNull
    public final KRecordFetchSpec<T> mappedBy(@NotNull BiFunction<TypeSystem, Record, T> mappingFunction) {
        Intrinsics.checkNotNullParameter(mappingFunction, (String)"mappingFunction");
        Neo4jClient.RecordFetchSpec<T> recordFetchSpec = this.delegate.mappedBy(mappingFunction);
        Intrinsics.checkNotNullExpressionValue(recordFetchSpec, (String)"mappedBy(...)");
        return new KRecordFetchSpec<T>(recordFetchSpec);
    }

    @Nullable
    public final T one() {
        return this.delegate.one().orElse(null);
    }

    @NotNull
    public final T first() {
        T t = this.delegate.first().orElse(null);
        Intrinsics.checkNotNullExpressionValue(t, (String)"orElse(...)");
        return t;
    }

    @NotNull
    public final Collection<T> all() {
        Collection collection = this.delegate.all();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"all(...)");
        return collection;
    }
}

