/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.PropertyHandlerSupport;
import org.springframework.data.neo4j.core.schema.Property;
import org.springframework.data.projection.MethodInterceptorFactory;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

final class EntityAndGraphPropertyAccessingMethodInterceptor
implements MethodInterceptor {
    private final BeanWrapper target;

    private EntityAndGraphPropertyAccessingMethodInterceptor(Object target, Neo4jMappingContext ctx) {
        Assert.notNull((Object)target, (String)"Proxy target must not be null");
        this.target = new GraphPropertyAndDirectFieldAccessFallbackBeanWrapper(target, ctx);
    }

    static MethodInterceptorFactory createMethodInterceptorFactory(final Neo4jMappingContext mappingContext) {
        return new MethodInterceptorFactory(){

            public MethodInterceptor createMethodInterceptor(Object source, Class<?> targetType) {
                return new EntityAndGraphPropertyAccessingMethodInterceptor(source, mappingContext);
            }

            public boolean supports(Object source, Class<?> targetType) {
                return true;
            }
        };
    }

    private static boolean isSetterMethod(Method method, PropertyDescriptor descriptor) {
        return method.equals(descriptor.getWriteMethod());
    }

    public @Nullable Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (ReflectionUtils.isObjectMethod((Method)method)) {
            return invocation.proceed();
        }
        PropertyDescriptor descriptor = BeanUtils.findPropertyForMethod((Method)method);
        if (descriptor == null) {
            throw new IllegalStateException("Invoked method is not a property accessor");
        }
        if (!EntityAndGraphPropertyAccessingMethodInterceptor.isSetterMethod(method, descriptor)) {
            return this.target.getPropertyValue(descriptor.getName());
        }
        if (invocation.getArguments().length != 1) {
            throw new IllegalStateException("Invoked setter method requires exactly one argument");
        }
        this.target.setPropertyValue(descriptor.getName(), invocation.getArguments()[0]);
        return null;
    }

    static class GraphPropertyAndDirectFieldAccessFallbackBeanWrapper
    extends DirectFieldAccessFallbackBeanWrapper {
        private final Neo4jMappingContext ctx;

        GraphPropertyAndDirectFieldAccessFallbackBeanWrapper(Object target, Neo4jMappingContext ctx) {
            super(target);
            this.ctx = ctx;
        }

        public @Nullable Object getPropertyValue(String propertyName) {
            try {
                return super.getPropertyValue(propertyName);
            }
            catch (NotReadablePropertyException ex) {
                Neo4jPersistentEntity entity = (Neo4jPersistentEntity)this.ctx.getPersistentEntity(super.getRootClass());
                AtomicReference value = new AtomicReference();
                if (entity != null) {
                    PropertyHandlerSupport.of(entity).doWithProperties((PropertyHandler<Neo4jPersistentProperty>)((PropertyHandler)p -> {
                        if (p.findAnnotation(Property.class) != null && p.getPropertyName().equals(propertyName)) {
                            value.compareAndSet(null, p.getFieldName());
                        }
                    }));
                    if (value.get() != null) {
                        return super.getPropertyValue((String)value.get());
                    }
                }
                throw ex;
            }
        }
    }
}

