/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Optional;
import java.util.Set;
import org.apiguardian.api.API;
import org.springframework.data.mapping.model.MutablePersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;

@API(status=API.Status.STABLE, since="6.0")
public interface Neo4jPersistentEntity<T>
extends MutablePersistentEntity<T, Neo4jPersistentProperty>,
NodeDescription<T> {
    public static final Set<Class<?>> DEPRECATED_GENERATED_ID_TYPES = Set.of(Long.class, Long.TYPE);

    public Optional<Neo4jPersistentProperty> getDynamicLabelsProperty();

    public boolean isRelationshipPropertiesEntity();

    public boolean hasRelationshipPropertyPersistTypeInfoFlag();

    default public boolean isUsingDeprecatedInternalId() {
        for (NodeDescription nodeDescription : this.getChildNodeDescriptionsInHierarchy()) {
            if (!nodeDescription.isUsingInternalIds() || ((Neo4jPersistentEntity)nodeDescription).getIdProperty() == null || !DEPRECATED_GENERATED_ID_TYPES.contains(((Neo4jPersistentProperty)((Neo4jPersistentEntity)nodeDescription).getIdProperty()).getType())) continue;
            return true;
        }
        return this.isUsingInternalIds() && DEPRECATED_GENERATED_ID_TYPES.contains(((Neo4jPersistentProperty)this.getRequiredIdProperty()).getType());
    }
}

