/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apiguardian.api.API;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.IsoDuration;
import org.neo4j.driver.types.Point;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.types.CartesianPoint2d;
import org.springframework.data.neo4j.types.CartesianPoint3d;
import org.springframework.data.neo4j.types.GeographicPoint2d;
import org.springframework.data.neo4j.types.GeographicPoint3d;

@API(status=API.Status.STABLE, since="6.0")
public final class Neo4jSimpleTypes {
    private static final Set<Class<?>> NEO4J_NATIVE_TYPES;
    public static final SimpleTypeHolder HOLDER;

    private Neo4jSimpleTypes() {
    }

    static {
        HashSet<Class<Object>> neo4jNativeTypes = new HashSet<Class<Object>>();
        neo4jNativeTypes.add(Instant.class);
        neo4jNativeTypes.add(IsoDuration.class);
        neo4jNativeTypes.add(LocalDate.class);
        neo4jNativeTypes.add(LocalDateTime.class);
        neo4jNativeTypes.add(LocalTime.class);
        neo4jNativeTypes.add(Map.class);
        neo4jNativeTypes.add(OffsetTime.class);
        neo4jNativeTypes.add(Point.class);
        neo4jNativeTypes.add(Void.class);
        neo4jNativeTypes.add(ZonedDateTime.class);
        neo4jNativeTypes.add(Void.TYPE);
        neo4jNativeTypes.add(UUID.class);
        neo4jNativeTypes.add(BigDecimal.class);
        neo4jNativeTypes.add(BigInteger.class);
        neo4jNativeTypes.add(org.springframework.data.geo.Point.class);
        neo4jNativeTypes.add(GeographicPoint2d.class);
        neo4jNativeTypes.add(GeographicPoint3d.class);
        neo4jNativeTypes.add(CartesianPoint2d.class);
        neo4jNativeTypes.add(CartesianPoint3d.class);
        neo4jNativeTypes.add(Value.class);
        NEO4J_NATIVE_TYPES = Collections.unmodifiableSet(neo4jNativeTypes);
        HOLDER = new SimpleTypeHolder(NEO4J_NATIVE_TYPES, true);
    }
}

