/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.lang.Nullable;

abstract class FluentQuerySupport<R> {
    protected final Class<R> resultType;
    protected final Sort sort;
    protected final Integer limit;
    @Nullable
    protected final Set<String> properties;

    FluentQuerySupport(Class<R> resultType, Sort sort, @Nullable Integer limit, @Nullable Collection<String> properties) {
        this.resultType = resultType;
        this.sort = sort;
        this.limit = limit;
        this.properties = properties != null ? new HashSet<String>(properties) : null;
    }

    final Predicate<PropertyFilter.RelaxedPropertyPath> createIncludedFieldsPredicate() {
        if (this.properties == null || this.properties.isEmpty()) {
            return PropertyFilter.NO_FILTER;
        }
        return path -> this.properties.contains(path.toDotPath());
    }

    final Collection<String> mergeProperties(Collection<String> additionalProperties) {
        HashSet<String> newProperties = new HashSet<String>();
        if (this.properties != null) {
            newProperties.addAll(this.properties);
        }
        newProperties.addAll(additionalProperties);
        return Collections.unmodifiableCollection(newProperties);
    }

    final Window<R> scroll(ScrollPosition scrollPosition, List<R> rawResult, Neo4jPersistentEntity<?> entity) {
        ScrollPosition.Direction scrollDirection;
        long skip;
        if (scrollPosition.isInitial()) {
            v0 = 0L;
        } else if (scrollPosition instanceof OffsetScrollPosition) {
            OffsetScrollPosition offsetScrollPosition = (OffsetScrollPosition)scrollPosition;
            v0 = offsetScrollPosition.getOffset();
        } else {
            v0 = skip = 0L;
        }
        if (scrollPosition instanceof KeysetScrollPosition) {
            KeysetScrollPosition keysetScrollPosition = (KeysetScrollPosition)scrollPosition;
            v1 = keysetScrollPosition.getDirection();
        } else {
            v1 = scrollDirection = ScrollPosition.Direction.FORWARD;
        }
        if (scrollDirection == ScrollPosition.Direction.BACKWARD) {
            Collections.reverse(rawResult);
        }
        IntFunction<ScrollPosition> positionFunction = null;
        positionFunction = scrollPosition instanceof OffsetScrollPosition ? OffsetScrollPosition.positionFunction((long)skip) : v -> {
            PersistentPropertyAccessor accessor = entity.getPropertyAccessor(rawResult.get(v));
            LinkedHashMap<String, Object> keys = new LinkedHashMap<String, Object>();
            this.sort.forEach(o -> {
                Neo4jPersistentProperty persistentProperty = (Neo4jPersistentProperty)entity.getRequiredPersistentProperty(o.getProperty());
                keys.put(persistentProperty.getPropertyName(), accessor.getProperty((PersistentProperty)persistentProperty));
            });
            keys.put("__stable_uniq_sort__", accessor.getProperty(entity.getRequiredIdProperty()));
            return ScrollPosition.forward(keys);
        };
        return Window.from(FluentQuerySupport.getSubList(rawResult, this.limit, scrollDirection), positionFunction, (boolean)FluentQuerySupport.hasMoreElements(rawResult, this.limit));
    }

    final Collection<String> extractAllPaths(Collection<String> projectingProperties) {
        if (projectingProperties.isEmpty()) {
            return new HashSet<String>();
        }
        HashSet<String> allPaths = new HashSet<String>();
        for (String property : projectingProperties) {
            if (property.contains(".")) {
                allPaths.addAll(Arrays.stream(property.split("\\.")).toList());
            }
            allPaths.add(property);
        }
        return allPaths;
    }

    private static boolean hasMoreElements(List<?> result, @Nullable Integer limit) {
        return !result.isEmpty() && result.size() > (limit != null ? limit : 0);
    }

    private static <T> List<T> getSubList(List<T> result, @Nullable Integer limit, ScrollPosition.Direction scrollDirection) {
        if (limit != null && limit > 0 && result.size() > limit) {
            return scrollDirection == ScrollPosition.Direction.FORWARD ? result.subList(0, limit) : result.subList(1, limit + 1);
        }
        return result;
    }
}

