/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.auditing.ReactiveIsNewAwareAuditingHandler;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.auditing.config.AuditingConfiguration;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.neo4j.config.EnableReactiveNeo4jAuditing;
import org.springframework.data.neo4j.core.mapping.callback.ReactiveAuditingBeforeBindCallback;
import org.springframework.util.Assert;

final class ReactiveNeo4jAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport {
    private static final String AUDITING_HANDLER_BEAN_NAME = "reactiveNeo4jAuditingHandler";
    private static final String MAPPING_CONTEXT_BEAN_NAME = "neo4jMappingContext";

    ReactiveNeo4jAuditingRegistrar() {
    }

    protected Class<? extends Annotation> getAnnotation() {
        return EnableReactiveNeo4jAuditing.class;
    }

    protected String getAuditingHandlerBeanName() {
        return AUDITING_HANDLER_BEAN_NAME;
    }

    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)auditingHandlerDefinition, (String)"BeanDefinition must not be null");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ReactiveAuditingBeforeBindCallback.class);
        builder.addConstructorArgValue((Object)ParsingUtils.getObjectFactoryBeanDefinition((String)this.getAuditingHandlerBeanName(), (Object)registry));
        builder.getRawBeanDefinition().setSource(auditingHandlerDefinition.getSource());
        this.registerInfrastructureBeanWithId(builder.getBeanDefinition(), ReactiveAuditingBeforeBindCallback.class.getName(), registry);
    }

    protected BeanDefinitionBuilder getAuditHandlerBeanDefinitionBuilder(AuditingConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"AuditingConfiguration must not be null");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ReactiveIsNewAwareAuditingHandler.class);
        BeanDefinitionBuilder persistentEntities = BeanDefinitionBuilder.genericBeanDefinition(PersistentEntities.class).setFactoryMethod("of");
        persistentEntities.addConstructorArgReference(MAPPING_CONTEXT_BEAN_NAME);
        builder.addConstructorArgValue((Object)persistentEntities.getBeanDefinition());
        return this.configureDefaultAuditHandlerAttributes(configuration, builder);
    }
}

