/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Query;
import org.neo4j.driver.QueryRunner;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.neo4j.core.DatabaseSelection;
import org.springframework.data.neo4j.core.DatabaseSelectionProvider;
import org.springframework.data.neo4j.core.NamedParameters;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jPersistenceExceptionTranslator;
import org.springframework.data.neo4j.core.ResultSummaries;
import org.springframework.data.neo4j.core.SingleValueMappingFunction;
import org.springframework.data.neo4j.core.UserSelection;
import org.springframework.data.neo4j.core.UserSelectionProvider;
import org.springframework.data.neo4j.core.convert.Neo4jConversions;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionManager;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class DefaultNeo4jClient
implements Neo4jClient {
    private final Driver driver;
    private final TypeSystem typeSystem;
    @Nullable
    private final DatabaseSelectionProvider databaseSelectionProvider;
    @Nullable
    private final UserSelectionProvider userSelectionProvider;
    private final ConversionService conversionService;
    private final Neo4jPersistenceExceptionTranslator persistenceExceptionTranslator = new Neo4jPersistenceExceptionTranslator();
    private final Set<Bookmark> bookmarks = new HashSet<Bookmark>();
    private final ReentrantReadWriteLock bookmarksLock = new ReentrantReadWriteLock();

    DefaultNeo4jClient(Neo4jClient.Builder builder) {
        this.driver = builder.driver;
        this.typeSystem = this.driver.defaultTypeSystem();
        this.databaseSelectionProvider = builder.databaseSelectionProvider;
        this.userSelectionProvider = builder.userSelectionProvider;
        this.conversionService = new DefaultConversionService();
        new Neo4jConversions().registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryRunner getQueryRunner(DatabaseSelection databaseSelection, UserSelection impersonatedUser) {
        Transaction queryRunner = Neo4jTransactionManager.retrieveTransaction(this.driver, databaseSelection, impersonatedUser);
        Set<Bookmark> lastBookmarks = Collections.emptySet();
        if (queryRunner == null) {
            ReentrantReadWriteLock.ReadLock lock = this.bookmarksLock.readLock();
            try {
                lock.lock();
                lastBookmarks = new HashSet<Bookmark>(this.bookmarks);
                queryRunner = this.driver.session(Neo4jTransactionUtils.sessionConfig(false, lastBookmarks, databaseSelection, impersonatedUser));
            }
            finally {
                lock.unlock();
            }
        }
        return new DelegatingQueryRunner((QueryRunner)queryRunner, lastBookmarks, (usedBookmarks, newBookmark) -> {
            ReentrantReadWriteLock.WriteLock lock = this.bookmarksLock.writeLock();
            try {
                lock.lock();
                this.bookmarks.removeAll((Collection<?>)usedBookmarks);
                this.bookmarks.add((Bookmark)newBookmark);
            }
            finally {
                lock.unlock();
            }
        });
    }

    @Override
    public Neo4jClient.UnboundRunnableSpec query(String cypher) {
        return this.query(() -> cypher);
    }

    @Override
    public Neo4jClient.UnboundRunnableSpec query(Supplier<String> cypherSupplier) {
        return new DefaultRunnableSpec(cypherSupplier);
    }

    @Override
    public <T> Neo4jClient.OngoingDelegation<T> delegateTo(Function<QueryRunner, Optional<T>> callback) {
        return new DefaultRunnableDelegation<T>(callback);
    }

    @Override
    @Nullable
    public DatabaseSelectionProvider getDatabaseSelectionProvider() {
        return this.databaseSelectionProvider;
    }

    private static RuntimeException potentiallyConvertRuntimeException(RuntimeException ex, PersistenceExceptionTranslator exceptionTranslator) {
        DataAccessException resolved = exceptionTranslator.translateExceptionIfPossible(ex);
        return resolved == null ? ex : resolved;
    }

    private DatabaseSelection resolveTargetDatabaseName(@Nullable String parameterTargetDatabase) {
        String value = Neo4jClient.verifyDatabaseName(parameterTargetDatabase);
        if (value != null) {
            return DatabaseSelection.byName(value);
        }
        if (this.databaseSelectionProvider != null) {
            return this.databaseSelectionProvider.getDatabaseSelection();
        }
        return DatabaseSelectionProvider.getDefaultSelectionProvider().getDatabaseSelection();
    }

    private UserSelection resolveUser(@Nullable String userName) {
        if (StringUtils.hasText((String)userName)) {
            return UserSelection.impersonate(userName);
        }
        if (this.userSelectionProvider != null) {
            return this.userSelectionProvider.getUserSelection();
        }
        return UserSelectionProvider.getDefaultSelectionProvider().getUserSelection();
    }

    class DefaultRunnableDelegation<T>
    implements Neo4jClient.RunnableDelegation<T>,
    Neo4jClient.OngoingDelegation<T> {
        private DatabaseSelection databaseSelection;
        @Nullable
        private UserSelection impersonatedUser;
        private final Function<QueryRunner, Optional<T>> callback;

        DefaultRunnableDelegation(Function<QueryRunner, Optional<T>> callback) {
            this.callback = callback;
            this.databaseSelection = DefaultNeo4jClient.this.resolveTargetDatabaseName(null);
            this.impersonatedUser = DefaultNeo4jClient.this.resolveUser(null);
        }

        @Override
        public Neo4jClient.RunnableDelegation<T> in(@Nullable String targetDatabase) {
            this.databaseSelection = DefaultNeo4jClient.this.resolveTargetDatabaseName(targetDatabase);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Optional<T> run() {
            try (QueryRunner queryRunner = DefaultNeo4jClient.this.getQueryRunner(this.databaseSelection, this.impersonatedUser);){
                Optional<T> optional = this.callback.apply(queryRunner);
                return optional;
            }
            catch (RuntimeException e) {
                throw DefaultNeo4jClient.potentiallyConvertRuntimeException(e, DefaultNeo4jClient.this.persistenceExceptionTranslator);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    class DefaultRecordFetchSpec<T>
    implements Neo4jClient.RecordFetchSpec<T>,
    Neo4jClient.MappingSpec<T> {
        private final DatabaseSelection databaseSelection;
        @Nullable
        private final UserSelection impersonatedUser;
        private final RunnableStatement runnableStatement;
        private BiFunction<TypeSystem, Record, T> mappingFunction;

        DefaultRecordFetchSpec(@Nullable DatabaseSelection databaseSelection, UserSelection impersonatedUser, RunnableStatement runnableStatement, BiFunction<TypeSystem, Record, T> mappingFunction) {
            this.databaseSelection = databaseSelection;
            this.impersonatedUser = impersonatedUser;
            this.runnableStatement = runnableStatement;
            this.mappingFunction = mappingFunction;
        }

        @Override
        public Neo4jClient.RecordFetchSpec<T> mappedBy(BiFunction<TypeSystem, Record, T> mappingFunction) {
            this.mappingFunction = mappingFunction;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Optional<T> one() {
            try (QueryRunner statementRunner = DefaultNeo4jClient.this.getQueryRunner(this.databaseSelection, this.impersonatedUser);){
                Result result = this.runnableStatement.runWith(statementRunner);
                Optional optionalValue = result.hasNext() ? Optional.ofNullable(this.mappingFunction.apply(DefaultNeo4jClient.this.typeSystem, result.single())) : Optional.empty();
                ResultSummaries.process(result.consume());
                Optional optional = optionalValue;
                return optional;
            }
            catch (RuntimeException e) {
                throw DefaultNeo4jClient.potentiallyConvertRuntimeException(e, DefaultNeo4jClient.this.persistenceExceptionTranslator);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Optional<T> first() {
            try (QueryRunner statementRunner = DefaultNeo4jClient.this.getQueryRunner(this.databaseSelection, this.impersonatedUser);){
                Result result = this.runnableStatement.runWith(statementRunner);
                Optional<Object> optionalValue = result.stream().map(this.partialMappingFunction(DefaultNeo4jClient.this.typeSystem)).filter(Objects::nonNull).findFirst();
                ResultSummaries.process(result.consume());
                Optional<Object> optional = optionalValue;
                return optional;
            }
            catch (RuntimeException e) {
                throw DefaultNeo4jClient.potentiallyConvertRuntimeException(e, DefaultNeo4jClient.this.persistenceExceptionTranslator);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Collection<T> all() {
            try (QueryRunner statementRunner = DefaultNeo4jClient.this.getQueryRunner(this.databaseSelection, this.impersonatedUser);){
                Result result = this.runnableStatement.runWith(statementRunner);
                Collection values = result.stream().map(this.partialMappingFunction(DefaultNeo4jClient.this.typeSystem)).filter(Objects::nonNull).collect(Collectors.toList());
                ResultSummaries.process(result.consume());
                Collection collection = values;
                return collection;
            }
            catch (RuntimeException e) {
                throw DefaultNeo4jClient.potentiallyConvertRuntimeException(e, DefaultNeo4jClient.this.persistenceExceptionTranslator);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Function<Record, T> partialMappingFunction(TypeSystem typeSystem) {
            return r -> this.mappingFunction.apply(typeSystem, (Record)r);
        }
    }

    class DefaultRunnableSpec
    implements Neo4jClient.UnboundRunnableSpec,
    Neo4jClient.RunnableSpecBoundToDatabaseAndUser {
        private final RunnableStatement runnableStatement;
        private DatabaseSelection databaseSelection;
        private UserSelection userSelection;

        DefaultRunnableSpec(Supplier<String> cypherSupplier) {
            this.databaseSelection = DefaultNeo4jClient.this.resolveTargetDatabaseName(null);
            this.userSelection = DefaultNeo4jClient.this.resolveUser(null);
            this.runnableStatement = new RunnableStatement(cypherSupplier);
        }

        @Override
        public Neo4jClient.RunnableSpecBoundToDatabase in(String targetDatabase) {
            this.databaseSelection = DefaultNeo4jClient.this.resolveTargetDatabaseName(targetDatabase);
            return new DefaultRunnableSpecBoundToDatabase();
        }

        @Override
        public Neo4jClient.RunnableSpecBoundToUser asUser(String asUser) {
            this.userSelection = DefaultNeo4jClient.this.resolveUser(asUser);
            return new DefaultRunnableSpecBoundToUser();
        }

        @Override
        public <T> Neo4jClient.OngoingBindSpec<T, Neo4jClient.RunnableSpec> bind(T value) {
            return new DefaultOngoingBindSpec<T>(value);
        }

        @Override
        public Neo4jClient.RunnableSpec bindAll(Map<String, Object> newParameters) {
            this.runnableStatement.parameters.addAll(newParameters);
            return this;
        }

        @Override
        public <T> Neo4jClient.MappingSpec<T> fetchAs(Class<T> targetClass) {
            return new DefaultRecordFetchSpec(this.databaseSelection, this.userSelection, this.runnableStatement, new SingleValueMappingFunction<T>(DefaultNeo4jClient.this.conversionService, targetClass));
        }

        @Override
        public Neo4jClient.RecordFetchSpec<Map<String, Object>> fetch() {
            return new DefaultRecordFetchSpec<Map<String, Object>>(this.databaseSelection, this.userSelection, this.runnableStatement, (t, r) -> r.asMap());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ResultSummary run() {
            try (QueryRunner statementRunner = DefaultNeo4jClient.this.getQueryRunner(this.databaseSelection, this.userSelection);){
                Result result = this.runnableStatement.runWith(statementRunner);
                ResultSummary resultSummary = ResultSummaries.process(result.consume());
                return resultSummary;
            }
            catch (RuntimeException e) {
                throw DefaultNeo4jClient.potentiallyConvertRuntimeException(e, DefaultNeo4jClient.this.persistenceExceptionTranslator);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        class DefaultRunnableSpecBoundToUser
        implements Neo4jClient.RunnableSpecBoundToUser {
            DefaultRunnableSpecBoundToUser() {
            }

            @Override
            public Neo4jClient.RunnableSpecBoundToDatabaseAndUser in(String aDatabase) {
                DefaultRunnableSpec.this.databaseSelection = DefaultNeo4jClient.this.resolveTargetDatabaseName(aDatabase);
                return DefaultRunnableSpec.this;
            }

            @Override
            public <T> Neo4jClient.MappingSpec<T> fetchAs(Class<T> targetClass) {
                return DefaultRunnableSpec.this.fetchAs(targetClass);
            }

            @Override
            public Neo4jClient.RecordFetchSpec<Map<String, Object>> fetch() {
                return DefaultRunnableSpec.this.fetch();
            }

            @Override
            public ResultSummary run() {
                return DefaultRunnableSpec.this.run();
            }

            @Override
            public <T> Neo4jClient.OngoingBindSpec<T, Neo4jClient.RunnableSpec> bind(T value) {
                return DefaultRunnableSpec.this.bind(value);
            }

            @Override
            public Neo4jClient.RunnableSpec bindAll(Map<String, Object> parameters) {
                return DefaultRunnableSpec.this.bindAll((Map)parameters);
            }
        }

        class DefaultRunnableSpecBoundToDatabase
        implements Neo4jClient.RunnableSpecBoundToDatabase {
            DefaultRunnableSpecBoundToDatabase() {
            }

            @Override
            public Neo4jClient.RunnableSpecBoundToDatabaseAndUser asUser(String aUser) {
                DefaultRunnableSpec.this.userSelection = DefaultNeo4jClient.this.resolveUser(aUser);
                return DefaultRunnableSpec.this;
            }

            @Override
            public <T> Neo4jClient.MappingSpec<T> fetchAs(Class<T> targetClass) {
                return DefaultRunnableSpec.this.fetchAs(targetClass);
            }

            @Override
            public Neo4jClient.RecordFetchSpec<Map<String, Object>> fetch() {
                return DefaultRunnableSpec.this.fetch();
            }

            @Override
            public ResultSummary run() {
                return DefaultRunnableSpec.this.run();
            }

            @Override
            public <T> Neo4jClient.OngoingBindSpec<T, Neo4jClient.RunnableSpec> bind(T value) {
                return DefaultRunnableSpec.this.bind(value);
            }

            @Override
            public Neo4jClient.RunnableSpec bindAll(Map<String, Object> parameters) {
                return DefaultRunnableSpec.this.bindAll((Map)parameters);
            }
        }

        class DefaultOngoingBindSpec<T>
        implements Neo4jClient.OngoingBindSpec<T, Neo4jClient.RunnableSpec> {
            @Nullable
            private final T value;

            DefaultOngoingBindSpec(T value) {
                this.value = value;
            }

            @Override
            public Neo4jClient.RunnableSpec to(String name) {
                DefaultRunnableSpec.this.runnableStatement.parameters.add(name, this.value);
                return DefaultRunnableSpec.this;
            }

            @Override
            public Neo4jClient.RunnableSpec with(Function<T, Map<String, Object>> binder) {
                Assert.notNull(binder, (String)"Binder is required.");
                return DefaultRunnableSpec.this.bindAll((Map)binder.apply(this.value));
            }
        }
    }

    static class RunnableStatement {
        private final Supplier<String> cypherSupplier;
        private final NamedParameters parameters;

        RunnableStatement(Supplier<String> cypherSupplier) {
            this(cypherSupplier, new NamedParameters());
        }

        RunnableStatement(Supplier<String> cypherSupplier, NamedParameters parameters) {
            this.cypherSupplier = cypherSupplier;
            this.parameters = parameters;
        }

        protected final Result runWith(QueryRunner statementRunner) {
            String statementTemplate = this.cypherSupplier.get();
            if (Neo4jClient.cypherLog.isDebugEnabled()) {
                Neo4jClient.cypherLog.debug(() -> String.format("Executing:%s%s", System.lineSeparator(), statementTemplate));
                if (Neo4jClient.cypherLog.isTraceEnabled() && !this.parameters.isEmpty()) {
                    Neo4jClient.cypherLog.trace(() -> String.format("with parameters:%s%s", System.lineSeparator(), this.parameters));
                }
            }
            return statementRunner.run(statementTemplate, this.parameters.get());
        }
    }

    private static class DelegatingQueryRunner
    implements QueryRunner {
        private final QueryRunner delegate;
        private final Collection<Bookmark> usedBookmarks;
        private final BiConsumer<Collection<Bookmark>, Bookmark> newBookmarkConsumer;

        private DelegatingQueryRunner(QueryRunner delegate, Collection<Bookmark> lastBookmarks, BiConsumer<Collection<Bookmark>, Bookmark> newBookmarkConsumer) {
            this.delegate = delegate;
            this.usedBookmarks = lastBookmarks;
            this.newBookmarkConsumer = newBookmarkConsumer;
        }

        public void close() throws Exception {
            if (this.delegate instanceof Session) {
                Session session = (Session)this.delegate;
                session.close();
                this.newBookmarkConsumer.accept(this.usedBookmarks, session.lastBookmark());
            }
        }

        public Result run(String s, Value value) {
            return this.delegate.run(s, value);
        }

        public Result run(String s, Map<String, Object> map) {
            return this.delegate.run(s, map);
        }

        public Result run(String s, Record record) {
            return this.delegate.run(s, record);
        }

        public Result run(String s) {
            return this.delegate.run(s);
        }

        public Result run(Query query) {
            return this.delegate.run(query);
        }
    }
}

