/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.util.AnnotationLiteral;
import org.apache.commons.logging.LogFactory;
import org.apiguardian.api.API;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.neo4j.config.Neo4jCdiConfigurationSupport;
import org.springframework.data.neo4j.repository.support.Neo4jRepositoryFactoryCdiBean;
import org.springframework.data.repository.cdi.CdiRepositoryExtensionSupport;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;

@API(status=API.Status.STABLE, since="6.0")
public final class Neo4jCdiExtension
extends CdiRepositoryExtensionSupport {
    public static final AnnotationLiteral<Default> DEFAULT_BEAN = new AnnotationLiteral<Default>(){

        public Class<? extends Annotation> annotationType() {
            return Default.class;
        }
    };
    public static final AnnotationLiteral<Any> ANY_BEAN = new AnnotationLiteral<Any>(){

        public Class<? extends Annotation> annotationType() {
            return Any.class;
        }
    };
    private static final LogAccessor log = new LogAccessor(LogFactory.getLog(Neo4jCdiExtension.class));

    public Neo4jCdiExtension() {
        log.info((CharSequence)"Activating CDI extension for Spring Data Neo4j repositories.");
    }

    void addNeo4jBeansProducer(@Observes BeforeBeanDiscovery event) {
        event.addAnnotatedType(Neo4jCdiConfigurationSupport.class, "Neo4jCDIConfigurationSupport");
    }

    void registerRepositoryFactoryBeanPerRepositoryType(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        Optional<CustomRepositoryImplementationDetector> optionalCustomRepositoryImplementationDetector = Optional.ofNullable(this.getCustomImplementationDetector());
        for (Map.Entry entry : this.getRepositoryTypes()) {
            Class repositoryType = (Class)entry.getKey();
            Set qualifiers = (Set)entry.getValue();
            Neo4jRepositoryFactoryCdiBean repositoryBean = new Neo4jRepositoryFactoryCdiBean(qualifiers, repositoryType, beanManager, optionalCustomRepositoryImplementationDetector);
            this.registerBean(repositoryBean);
            event.addBean(repositoryBean);
        }
    }
}

