/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.support;

import java.util.Date;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverterFactory;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.support.DateString;
import org.springframework.data.neo4j.core.support.DateStringConverter;

final class DateStringConverterFactory
implements Neo4jPersistentPropertyConverterFactory {
    DateStringConverterFactory() {
    }

    @Override
    public Neo4jPersistentPropertyConverter getPropertyConverterFor(Neo4jPersistentProperty persistentProperty) {
        if (persistentProperty.getActualType() == Date.class) {
            DateString config = (DateString)persistentProperty.getRequiredAnnotation(DateString.class);
            return new DateStringConverter(config.value());
        }
        throw new UnsupportedOperationException("Other types than java.util.Date are not yet supported. Please file a ticket.");
    }
}

