/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import org.apiguardian.api.API;
import org.neo4j.driver.Driver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.Neo4jConfigurationSupport;
import org.springframework.data.neo4j.core.ReactiveDatabaseSelectionProvider;
import org.springframework.data.neo4j.core.ReactiveNeo4jClient;
import org.springframework.data.neo4j.core.ReactiveNeo4jTemplate;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.transaction.ReactiveNeo4jTransactionManager;
import org.springframework.transaction.ReactiveTransactionManager;

@Configuration
@API(status=API.Status.STABLE, since="6.0")
public abstract class AbstractReactiveNeo4jConfig
extends Neo4jConfigurationSupport {
    public abstract Driver driver();

    @Bean(value={"reactiveNeo4jClient"})
    public ReactiveNeo4jClient neo4jClient(Driver driver, ReactiveDatabaseSelectionProvider databaseNameProvider) {
        return ReactiveNeo4jClient.create(driver, databaseNameProvider);
    }

    @Bean(value={"reactiveNeo4jTemplate"})
    public ReactiveNeo4jTemplate neo4jTemplate(ReactiveNeo4jClient neo4jClient, Neo4jMappingContext mappingContext) {
        return new ReactiveNeo4jTemplate(neo4jClient, mappingContext);
    }

    @Bean(value={"reactiveTransactionManager"})
    public ReactiveTransactionManager reactiveTransactionManager(Driver driver, ReactiveDatabaseSelectionProvider databaseNameProvider) {
        return new ReactiveNeo4jTransactionManager(driver, databaseNameProvider);
    }

    @Bean
    protected ReactiveDatabaseSelectionProvider reactiveDatabaseSelectionProvider() {
        return ReactiveDatabaseSelectionProvider.getDefaultSelectionProvider();
    }
}

