/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apiguardian.api.API;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0")
public final class NestedRelationshipProcessingStateMachine {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock read = this.lock.readLock();
    private final Lock write = this.lock.writeLock();
    private final Set<RelationshipDescriptionWithSourceId> processedRelationshipDescriptions = new HashSet<RelationshipDescriptionWithSourceId>();
    private final Set<Object> processedObjects = new HashSet<Object>();
    private final Map<Object, Object> processedObjectsAlias = new HashMap<Object, Object>();
    private final Map<Object, Long> processedObjectsIds = new HashMap<Object, Long>();

    public NestedRelationshipProcessingStateMachine(Object initialObject, Long internalId) {
        this(initialObject);
        this.processedObjectsIds.put(initialObject, internalId);
    }

    public NestedRelationshipProcessingStateMachine(Object initialObject) {
        this.processedObjects.add(initialObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessState getStateOf(Object fromId, RelationshipDescription relationshipDescription, @Nullable Collection<?> valuesToStore) {
        try {
            this.read.lock();
            boolean hasProcessedRelationship = this.hasProcessedRelationship(fromId, relationshipDescription);
            boolean hasProcessedAllValues = this.hasProcessedAllOf(valuesToStore);
            if (hasProcessedRelationship && hasProcessedAllValues) {
                ProcessState processState = ProcessState.PROCESSED_BOTH;
                return processState;
            }
            if (hasProcessedRelationship) {
                ProcessState processState = ProcessState.PROCESSED_ALL_RELATIONSHIPS;
                return processState;
            }
            if (hasProcessedAllValues) {
                ProcessState processState = ProcessState.PROCESSED_ALL_VALUES;
                return processState;
            }
            ProcessState processState = ProcessState.PROCESSED_NONE;
            return processState;
        }
        finally {
            this.read.unlock();
        }
    }

    public void markRelationshipAsProcessed(Object fromId, @Nullable RelationshipDescription relationshipDescription) {
        if (relationshipDescription == null) {
            return;
        }
        try {
            this.write.lock();
            this.processedRelationshipDescriptions.add(new RelationshipDescriptionWithSourceId(fromId, relationshipDescription));
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markValueAsProcessed(Object valueToStore, Long internalId) {
        try {
            this.write.lock();
            Object value = this.extractRelatedValueFromRelationshipProperties(valueToStore);
            this.processedObjects.add(valueToStore);
            this.processedObjects.add(value);
            if (internalId != null) {
                this.processedObjectsIds.put(valueToStore, internalId);
                this.processedObjectsIds.put(value, internalId);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProcessedValue(Object value) {
        try {
            this.read.lock();
            Object valueToCheck = this.extractRelatedValueFromRelationshipProperties(value);
            boolean bl = this.processedObjects.contains(valueToCheck) || this.processedObjectsAlias.containsKey(valueToCheck);
            return bl;
        }
        finally {
            this.read.unlock();
        }
    }

    public boolean hasProcessedRelationship(Object fromId, @Nullable RelationshipDescription relationshipDescription) {
        if (relationshipDescription != null) {
            return this.processedRelationshipDescriptions.contains(new RelationshipDescriptionWithSourceId(fromId, relationshipDescription));
        }
        return false;
    }

    public void markValueAsProcessedAs(Object relatedValueToStore, Object bean) {
        try {
            this.write.lock();
            this.processedObjectsAlias.put(relatedValueToStore, bean);
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Long getInternalId(Object object) {
        try {
            this.read.lock();
            Object valueToCheck = this.extractRelatedValueFromRelationshipProperties(object);
            Long possibleId = this.processedObjectsIds.get(valueToCheck);
            Long l = possibleId != null ? possibleId : this.processedObjectsIds.get(this.processedObjectsAlias.get(valueToCheck));
            return l;
        }
        finally {
            this.read.unlock();
        }
    }

    public Object getProcessedAs(Object entity) {
        try {
            this.read.lock();
            Object object = this.processedObjectsAlias.getOrDefault(entity, entity);
            return object;
        }
        finally {
            this.read.unlock();
        }
    }

    private boolean hasProcessedAllOf(@Nullable Collection<?> valuesToStore) {
        if (valuesToStore == null) {
            return false;
        }
        return this.processedObjects.containsAll(valuesToStore);
    }

    @NonNull
    private Object extractRelatedValueFromRelationshipProperties(Object valueToStore) {
        Object value = valueToStore instanceof MappingSupport.RelationshipPropertiesWithEntityHolder ? ((MappingSupport.RelationshipPropertiesWithEntityHolder)valueToStore).getRelatedEntity() : valueToStore;
        return value;
    }

    private static class RelationshipDescriptionWithSourceId {
        private final Object id;
        private final RelationshipDescription relationshipDescription;

        RelationshipDescriptionWithSourceId(Object id, RelationshipDescription relationshipDescription) {
            this.id = id;
            this.relationshipDescription = relationshipDescription;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelationshipDescriptionWithSourceId that = (RelationshipDescriptionWithSourceId)o;
            return this.id.equals(that.id) && this.relationshipDescription.equals(that.relationshipDescription);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.relationshipDescription);
        }
    }

    public static enum ProcessState {
        PROCESSED_NONE,
        PROCESSED_BOTH,
        PROCESSED_ALL_RELATIONSHIPS,
        PROCESSED_ALL_VALUES;

    }
}

