/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Relationship;
import org.neo4j.driver.types.Type;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.schema.TargetNode;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0")
public final class MappingSupport {
    public static Collection<?> unifyRelationshipValue(Neo4jPersistentProperty property, @Nullable Object rawValue) {
        if (rawValue == null) {
            return Collections.emptyList();
        }
        Collection<Object> unifiedValue = property.isDynamicAssociation() ? (property.isDynamicOneToManyAssociation() ? (Collection)((Map)rawValue).entrySet().stream().flatMap(e -> ((Collection)e.getValue()).stream().map(v -> new AbstractMap.SimpleEntry(e.getKey(), v))).collect(Collectors.toList()) : ((Map)rawValue).entrySet()) : (property.isCollectionLike() ? (Set<Object>)rawValue : Collections.singleton(rawValue));
        return unifiedValue;
    }

    public static Predicate<Value> isListContainingOnly(Type collectionType, Type requiredType) {
        Predicate<Value> containsOnlyRequiredType = entry -> {
            for (Value listEntry : entry.values()) {
                if (listEntry.hasType(collectionType)) {
                    boolean listInListCorrectType = true;
                    for (Value listInListEntry : entry.asList(Function.identity())) {
                        listInListCorrectType = listInListCorrectType && MappingSupport.isListContainingOnly(collectionType, requiredType).test(listInListEntry);
                    }
                    return listInListCorrectType;
                }
                if (listEntry.hasType(requiredType)) continue;
                return false;
            }
            return true;
        };
        Predicate<Value> isList = entry -> entry.hasType(collectionType);
        return isList.and(containsOnlyRequiredType);
    }

    static Collection<Relationship> extractRelationships(Type collectionType, Value entry) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        for (Value listEntry : entry.values()) {
            if (listEntry.hasType(collectionType)) {
                for (Value listInListEntry : entry.asList(Function.identity())) {
                    relationships.addAll(MappingSupport.extractRelationships(collectionType, listInListEntry));
                }
                continue;
            }
            relationships.add(listEntry.asRelationship());
        }
        return relationships;
    }

    static Collection<Node> extractNodes(Type collectionType, Value entry) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Value listEntry : entry.values()) {
            if (listEntry.hasType(collectionType)) {
                for (Value listInListEntry : entry.asList(Function.identity())) {
                    nodes.addAll(MappingSupport.extractNodes(collectionType, listInListEntry));
                }
                continue;
            }
            nodes.add(listEntry.asNode());
        }
        return nodes;
    }

    public static Object getRelationshipOrRelationshipPropertiesObject(Neo4jMappingContext neo4jMappingContext, boolean hasRelationshipProperties, boolean isDynamicAssociation, Object valueToStore, PersistentPropertyAccessor<?> propertyAccessor) {
        Object newRelationshipObject = propertyAccessor.getBean();
        if (hasRelationshipProperties) {
            RelationshipPropertiesWithEntityHolder entityHolder = (RelationshipPropertiesWithEntityHolder)(isDynamicAssociation ? ((Map.Entry)valueToStore).getValue() : valueToStore);
            Object relationshipPropertiesValue = entityHolder.getRelationshipProperties();
            Neo4jPersistentEntity persistentEntity = (Neo4jPersistentEntity)neo4jMappingContext.getPersistentEntity(relationshipPropertiesValue.getClass());
            PersistentPropertyAccessor relationshipPropertiesAccessor = persistentEntity.getPropertyAccessor(relationshipPropertiesValue);
            relationshipPropertiesAccessor.setProperty(persistentEntity.getPersistentProperty(TargetNode.class), newRelationshipObject);
            newRelationshipObject = relationshipPropertiesAccessor.getBean();
        }
        return newRelationshipObject;
    }

    private MappingSupport() {
    }

    @API(status=API.Status.INTERNAL)
    public static final class RelationshipPropertiesWithEntityHolder {
        private final PersistentPropertyAccessor<?> relationshipPropertiesPropertyAccessor;
        private final Object relationshipProperties;
        private final Object relatedEntity;

        RelationshipPropertiesWithEntityHolder(Neo4jPersistentEntity<?> relationshipPropertiesEntity, Object relationshipProperties, Object relatedEntity) {
            this.relationshipPropertiesPropertyAccessor = relationshipPropertiesEntity.getPropertyAccessor(relationshipProperties);
            this.relationshipProperties = relationshipProperties;
            this.relatedEntity = relatedEntity;
        }

        public PersistentPropertyAccessor<?> getRelationshipPropertiesPropertyAccessor() {
            return this.relationshipPropertiesPropertyAccessor;
        }

        public Object getRelationshipProperties() {
            return this.relationshipProperties;
        }

        public Object getRelatedEntity() {
            return this.relatedEntity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelationshipPropertiesWithEntityHolder that = (RelationshipPropertiesWithEntityHolder)o;
            return this.relationshipProperties.equals(that.relationshipProperties) && this.relatedEntity.equals(that.relatedEntity);
        }

        public int hashCode() {
            return Objects.hash(this.relationshipProperties, this.relatedEntity);
        }
    }
}

