/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.EntityInstanceWithSource;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.QueryFragments;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@API(status=API.Status.INTERNAL, since="6.0.9")
public final class TemplateSupport {
    @Nullable
    public static Class<?> findCommonElementType(Iterable<?> collection) {
        if (collection == null) {
            return null;
        }
        Collection allClasses = StreamSupport.stream(collection.spliterator(), true).filter(o -> o != null).map(Object::getClass).collect(Collectors.toSet());
        Class candidate = null;
        for (Class type : allClasses) {
            if (candidate == null) {
                candidate = type;
                continue;
            }
            if (candidate == type) continue;
            candidate = null;
            break;
        }
        if (candidate != null) {
            return candidate;
        }
        Predicate<Class> moveUp = c -> c != null && c != Object.class;
        HashSet mostAbstractClasses = new HashSet();
        for (Class type : allClasses) {
            while (moveUp.test(type.getSuperclass())) {
                type = type.getSuperclass();
            }
            mostAbstractClasses.add(type);
        }
        Class clazz = candidate = mostAbstractClasses.size() == 1 ? (Class)mostAbstractClasses.iterator().next() : null;
        if (candidate != null) {
            return candidate;
        }
        List<Set> interfacesPerClass = allClasses.stream().map(c -> Arrays.stream(c.getInterfaces()).collect(Collectors.toSet())).collect(Collectors.toList());
        Set allInterfaces = interfacesPerClass.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        interfacesPerClass.forEach(setOfInterfaces -> allInterfaces.removeIf(iface -> !setOfInterfaces.contains(iface)));
        candidate = allInterfaces.size() == 1 ? (Class)allInterfaces.iterator().next() : null;
        return candidate;
    }

    static Predicate<String> computeIncludePropertyPredicate(List<PropertyDescriptor> includedProperties) {
        if (includedProperties == null) {
            return p -> true;
        }
        Set includedPropertyNames = includedProperties.stream().map(FeatureDescriptor::getName).collect(Collectors.toSet());
        return includedPropertyNames::contains;
    }

    static void updateVersionPropertyIfPossible(Neo4jPersistentEntity<?> entityMetaData, PersistentPropertyAccessor<?> propertyAccessor, Entity newOrUpdatedNode) {
        if (entityMetaData.hasVersionProperty()) {
            propertyAccessor.setProperty(entityMetaData.getVersionProperty(), (Object)newOrUpdatedNode.get(((Neo4jPersistentProperty)entityMetaData.getVersionProperty()).getPropertyName()).asLong());
        }
    }

    static Map<String, Object> mergeParameters(Statement statement, @Nullable Map<String, Object> parameters) {
        HashMap<String, Object> mergedParameters = new HashMap<String, Object>(statement.getParameters());
        if (parameters != null) {
            mergedParameters.putAll(parameters);
        }
        return mergedParameters;
    }

    static <T> BiFunction<TypeSystem, MapAccessor, ?> getAndDecorateMappingFunction(Neo4jMappingContext mappingContext, Class<T> domainType, @Nullable Class<?> resultType) {
        Assert.notNull((Object)mappingContext.getPersistentEntity(domainType), (String)"Cannot get or create persistent entity.");
        BiFunction<TypeSystem, MapAccessor, ?> mappingFunction = mappingContext.getRequiredMappingFunctionFor(domainType);
        if (resultType != null && domainType != resultType && !resultType.isInterface()) {
            mappingFunction = EntityInstanceWithSource.decorateMappingFunction(mappingFunction);
        }
        return mappingFunction;
    }

    private TemplateSupport() {
    }

    static final class NodesAndRelationshipsByIdStatementProvider {
        private static final String ROOT_NODE_IDS = "rootNodeIds";
        private static final String RELATIONSHIP_IDS = "relationshipIds";
        private static final String RELATED_NODE_IDS = "relatedNodeIds";
        static final NodesAndRelationshipsByIdStatementProvider EMPTY = new NodesAndRelationshipsByIdStatementProvider(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), new QueryFragments());
        private final Map<String, Collection<Long>> parameters = new HashMap<String, Collection<Long>>(3);
        private final QueryFragments queryFragments;

        NodesAndRelationshipsByIdStatementProvider(Collection<Long> rootNodeIds, Collection<Long> relationshipsIds, Collection<Long> relatedNodeIds, QueryFragments queryFragments) {
            this.parameters.put(ROOT_NODE_IDS, rootNodeIds);
            this.parameters.put(RELATIONSHIP_IDS, relationshipsIds);
            this.parameters.put(RELATED_NODE_IDS, relatedNodeIds);
            this.queryFragments = queryFragments;
        }

        Map<String, Object> getParameters() {
            return Collections.unmodifiableMap(this.parameters);
        }

        boolean hasRootNodeIds() {
            return this.parameters.get(ROOT_NODE_IDS).isEmpty();
        }

        Statement toStatement() {
            String rootNodeIds = ROOT_NODE_IDS;
            String relationshipIds = RELATIONSHIP_IDS;
            String relatedNodeIds = RELATED_NODE_IDS;
            Node rootNodes = Cypher.anyNode((String)rootNodeIds);
            Node relatedNodes = Cypher.anyNode((String)relatedNodeIds);
            Relationship relationships = ((Relationship)Cypher.anyNode().relationshipBetween(Cypher.anyNode(), new String[0])).named(relationshipIds);
            return Cypher.match((PatternElement[])new PatternElement[]{rootNodes}).where(Functions.id((Node)rootNodes).in((Expression)Cypher.parameter((String)rootNodeIds))).optionalMatch(new PatternElement[]{relationships}).where(Functions.id((Relationship)relationships).in((Expression)Cypher.parameter((String)relationshipIds))).optionalMatch(new PatternElement[]{relatedNodes}).where(Functions.id((Node)relatedNodes).in((Expression)Cypher.parameter((String)relatedNodeIds))).with(new AliasedExpression[]{rootNodes.as(Constants.NAME_OF_ROOT_NODE.getValue()), Functions.collectDistinct((Named)relationships).as("__sr__"), Functions.collectDistinct((Named)relatedNodes).as("__srn__")}).orderBy(this.queryFragments.getOrderBy()).returning(new Expression[]{Constants.NAME_OF_ROOT_NODE.as("__sn__"), Cypher.name((String)"__sr__"), Cypher.name((String)"__srn__")}).skip((Number)this.queryFragments.getSkip()).limit(this.queryFragments.getLimit()).build();
        }
    }

    static enum FetchType {
        ONE,
        ALL;

    }
}

