/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metrics;
import org.springframework.data.neo4j.core.convert.Neo4jSimpleTypes;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.query.BoundingBox;
import org.springframework.data.neo4j.repository.query.EntityInstanceWithSource;
import org.springframework.data.neo4j.repository.query.Neo4jNestedMapEntityWriter;
import org.springframework.data.neo4j.repository.query.Neo4jParameterAccessor;
import org.springframework.data.neo4j.repository.query.Neo4jQueryMethod;
import org.springframework.data.neo4j.repository.query.Neo4jQueryType;
import org.springframework.data.neo4j.repository.query.Neo4jSpelSupport;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

abstract class Neo4jQuerySupport {
    protected final Neo4jMappingContext mappingContext;
    protected final Neo4jQueryMethod queryMethod;
    protected final Neo4jQueryType queryType;
    static final LogAccessor REPOSITORY_QUERY_LOG = new LogAccessor(LogFactory.getLog(Neo4jQuerySupport.class));

    static Class<?> getDomainType(QueryMethod queryMethod) {
        return queryMethod.getResultProcessor().getReturnedType().getDomainType();
    }

    Neo4jQuerySupport(Neo4jMappingContext mappingContext, Neo4jQueryMethod queryMethod, Neo4jQueryType queryType) {
        Assert.notNull((Object)mappingContext, (String)"The mapping context is required.");
        Assert.notNull((Object)((Object)queryMethod), (String)"Query method must not be null!");
        Assert.notNull((Object)((Object)queryType), (String)"Query type must not be null!");
        this.mappingContext = mappingContext;
        this.queryMethod = queryMethod;
        this.queryType = queryType;
    }

    protected final BiFunction<TypeSystem, MapAccessor, ?> getMappingFunction(ResultProcessor resultProcessor) {
        BiFunction<TypeSystem, MapAccessor, Object> mappingFunction;
        ReturnedType returnedTypeMetadata = resultProcessor.getReturnedType();
        Class returnedType = returnedTypeMetadata.getReturnedType();
        Class domainType = returnedTypeMetadata.getDomainType();
        if (Neo4jSimpleTypes.HOLDER.isSimpleType(returnedType)) {
            mappingFunction = null;
        } else if (returnedTypeMetadata.isProjecting()) {
            BiFunction target = this.mappingContext.getRequiredMappingFunctionFor(domainType);
            mappingFunction = (t, r) -> new EntityInstanceWithSource(target.apply(t, r), (TypeSystem)t, (MapAccessor)r);
        } else {
            mappingFunction = this.mappingContext.getRequiredMappingFunctionFor(domainType);
        }
        return mappingFunction;
    }

    protected final List<String> getInputProperties(ResultProcessor resultProcessor) {
        ReturnedType returnedType = resultProcessor.getReturnedType();
        return returnedType.isProjecting() ? returnedType.getInputProperties() : Collections.emptyList();
    }

    final Object convertParameter(Object parameter) {
        return this.convertParameter(parameter, null);
    }

    final Object convertParameter(Object parameter, @Nullable Function<Object, Value> conversionOverride) {
        if (parameter == null) {
            REPOSITORY_QUERY_LOG.warn((CharSequence)"Do not use `null` as a property value for comparison. It will always be false and return an empty result.");
            return Values.NULL;
        }
        if (parameter instanceof Range) {
            return this.convertRange((Range)parameter);
        }
        if (parameter instanceof Distance) {
            return Neo4jQuerySupport.calculateDistanceInMeter((Distance)parameter);
        }
        if (parameter instanceof Circle) {
            return this.convertCircle((Circle)parameter);
        }
        if (parameter instanceof Instant) {
            return ((Instant)parameter).atOffset(ZoneOffset.UTC);
        }
        if (parameter instanceof Box) {
            return this.convertBox((Box)parameter);
        }
        if (parameter instanceof BoundingBox) {
            return this.convertBoundingBox((BoundingBox)parameter);
        }
        if (this.mappingContext.hasPersistentEntityFor(parameter.getClass())) {
            HashMap result = new HashMap();
            Neo4jNestedMapEntityWriter.forContext(this.mappingContext).write(parameter, result);
            return result;
        }
        return this.mappingContext.getConversionService().writeValue(parameter, (TypeInformation<?>)ClassTypeInformation.from(parameter.getClass()), conversionOverride);
    }

    void replaceLiteralsIn(QueryContext queryContext) {
        String cypherQuery = queryContext.template;
        Iterator<Map.Entry<String, Object>> iterator = queryContext.boundParameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            Object value = entry.getValue();
            if (!(value instanceof Neo4jSpelSupport.LiteralReplacement)) continue;
            iterator.remove();
            String key = entry.getKey();
            cypherQuery = cypherQuery.replace("$" + key, ((Neo4jSpelSupport.LiteralReplacement)value).getValue());
            queryContext.hasLiteralReplacementForSort = queryContext.hasLiteralReplacementForSort || ((Neo4jSpelSupport.LiteralReplacement)value).getTarget() == Neo4jSpelSupport.LiteralReplacement.Target.SORT;
        }
        queryContext.query = cypherQuery;
    }

    void logWarningsIfNecessary(QueryContext queryContext, Neo4jParameterAccessor parameterAccessor) {
        if (!queryContext.hasLiteralReplacementForSort && !parameterAccessor.getSort().isUnsorted()) {
            REPOSITORY_QUERY_LOG.warn(() -> String.format("You passed a sorted request to the custom query for '%s'. SDN won't apply any sort information from that object to the query. Please specify the order in the query itself and use an unsorted request or use the SpEL extension `:#{orderBy(#sort)}`.", queryContext.repositoryMethodName));
            String fragment = CypherGenerator.INSTANCE.createOrderByFragment(parameterAccessor.getSort());
            if (fragment != null) {
                REPOSITORY_QUERY_LOG.warn(() -> String.format("One possible order clause matching your page reguest would be the following fragment:%n%s", fragment));
            }
        }
    }

    private Map<String, Object> convertRange(Range range) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        range.getLowerBound().getValue().map(this::convertParameter).ifPresent(v -> map.put("lb", v));
        range.getUpperBound().getValue().map(this::convertParameter).ifPresent(v -> map.put("ub", v));
        return map;
    }

    private Map<String, Object> convertCircle(Circle circle) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", this.convertParameter(circle.getCenter().getX()));
        map.put("y", this.convertParameter(circle.getCenter().getY()));
        map.put("radius", this.convertParameter(Neo4jQuerySupport.calculateDistanceInMeter(circle.getRadius())));
        return map;
    }

    private Map<String, Object> convertBox(Box box) {
        BoundingBox boundingBox = BoundingBox.of(box);
        return this.convertBoundingBox(boundingBox);
    }

    private Map<String, Object> convertBoundingBox(BoundingBox boundingBox) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("llx", this.convertParameter(boundingBox.getLowerLeft().getX()));
        map.put("lly", this.convertParameter(boundingBox.getLowerLeft().getY()));
        map.put("urx", this.convertParameter(boundingBox.getUpperRight().getX()));
        map.put("ury", this.convertParameter(boundingBox.getUpperRight().getY()));
        return map;
    }

    private static double calculateDistanceInMeter(Distance distance) {
        if (distance.getMetric() == Metrics.KILOMETERS) {
            double kilometersDivisor = 0.001;
            return distance.getValue() / kilometersDivisor;
        }
        if (distance.getMetric() == Metrics.MILES) {
            double milesDivisor = 6.2137E-4;
            return distance.getValue() / milesDivisor;
        }
        return distance.getValue();
    }

    static class QueryContext {
        final String repositoryMethodName;
        final String template;
        final Map<String, Object> boundParameters;
        String query;
        private boolean hasLiteralReplacementForSort = false;

        QueryContext(String repositoryMethodName, String template, Map<String, Object> boundParameters) {
            this.repositoryMethodName = repositoryMethodName;
            this.query = this.template = template;
            this.boundParameters = boundParameters;
        }
    }
}

