/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.transaction;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.neo4j.driver.Bookmark;

final class Neo4jBookmarkManager {
    private Set<Bookmark> bookmarks = new HashSet<Bookmark>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock read = this.lock.readLock();
    private final Lock write = this.lock.writeLock();

    Neo4jBookmarkManager() {
    }

    Collection<Bookmark> getBookmarks() {
        try {
            this.read.lock();
            Set<Bookmark> set = Collections.unmodifiableSet(new HashSet<Bookmark>(this.bookmarks));
            return set;
        }
        finally {
            this.read.unlock();
        }
    }

    void updateBookmarks(Collection<Bookmark> usedBookmarks, Bookmark lastBookmark) {
        try {
            this.write.lock();
            this.bookmarks.removeAll(usedBookmarks);
            this.bookmarks.add(lastBookmark);
        }
        finally {
            this.write.unlock();
        }
    }
}

