/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.springframework.core.CollectionFactory;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;

@API(status=API.Status.INTERNAL, since="6.1")
final class RelationshipHandler {
    private final Neo4jPersistentProperty property;
    private final Object rawValue;
    private final Cardinality cardinality;
    private Collection<Object> newRelatedObjects;
    private final Map<Object, Object> newRelatedObjectsByType;

    static RelationshipHandler forProperty(Neo4jPersistentProperty property, Object rawValue) {
        Cardinality cardinality;
        Collection newRelationshipObjectCollection = null;
        Map newRelationshipObjectCollectionMap = null;
        if (property.isCollectionLike()) {
            cardinality = Cardinality.ONE_TO_MANY;
            newRelationshipObjectCollection = CollectionFactory.createApproximateCollection((Object)rawValue, (int)((Collection)rawValue).size());
        } else if (property.isDynamicOneToManyAssociation()) {
            cardinality = Cardinality.DYNAMIC_ONE_TO_MANY;
            newRelationshipObjectCollectionMap = CollectionFactory.createApproximateMap((Object)rawValue, (int)((Map)rawValue).size());
        } else if (property.isDynamicAssociation()) {
            cardinality = Cardinality.DYNAMIC_ONE_TO_ONE;
            newRelationshipObjectCollectionMap = CollectionFactory.createApproximateMap((Object)rawValue, (int)((Map)rawValue).size());
        } else {
            cardinality = Cardinality.ONE_TO_ONE;
        }
        return new RelationshipHandler(property, rawValue, cardinality, newRelationshipObjectCollection, newRelationshipObjectCollectionMap);
    }

    RelationshipHandler(Neo4jPersistentProperty property, Object rawValue, Cardinality cardinality, Collection<Object> newRelatedObjects, Map<Object, Object> newRelatedObjectsByType) {
        this.property = property;
        this.rawValue = rawValue;
        this.cardinality = cardinality;
        this.newRelatedObjects = newRelatedObjects;
        this.newRelatedObjectsByType = newRelatedObjectsByType;
    }

    void handle(Object relatedValueToStore, Object newRelatedObject, Object potentiallyRecreatedRelatedObject) {
        if (potentiallyRecreatedRelatedObject == newRelatedObject) {
            return;
        }
        if (this.cardinality == Cardinality.ONE_TO_ONE) {
            this.newRelatedObjects = Collections.singletonList(potentiallyRecreatedRelatedObject);
        } else if (this.cardinality == Cardinality.ONE_TO_MANY) {
            this.newRelatedObjects.add(potentiallyRecreatedRelatedObject);
        } else {
            Object key = ((Map.Entry)relatedValueToStore).getKey();
            if (this.cardinality == Cardinality.DYNAMIC_ONE_TO_ONE) {
                this.newRelatedObjectsByType.put(key, potentiallyRecreatedRelatedObject);
            } else {
                Collection newCollection = (Collection)this.newRelatedObjectsByType.computeIfAbsent(key, k -> CollectionFactory.createCollection((Class)this.property.getTypeInformation().getRequiredActualType().getType(), (int)((Collection)((Map)this.rawValue).get(key)).size()));
                newCollection.add(potentiallyRecreatedRelatedObject);
            }
        }
    }

    void applyFinalResultToOwner(PersistentPropertyAccessor<?> parentPropertyAccessor) {
        Object finalRelation = null;
        switch (this.cardinality) {
            case ONE_TO_ONE: {
                finalRelation = this.newRelatedObjects == null ? null : ((List)this.newRelatedObjects).get(0);
                break;
            }
            case ONE_TO_MANY: {
                if (this.newRelatedObjects.isEmpty()) break;
                finalRelation = this.newRelatedObjects;
                break;
            }
            case DYNAMIC_ONE_TO_ONE: 
            case DYNAMIC_ONE_TO_MANY: {
                if (this.newRelatedObjectsByType.isEmpty()) break;
                finalRelation = this.newRelatedObjectsByType;
            }
        }
        if (finalRelation != null) {
            parentPropertyAccessor.setProperty((PersistentProperty)this.property, finalRelation);
        }
    }

    static enum Cardinality {
        ONE_TO_ONE,
        ONE_TO_MANY,
        DYNAMIC_ONE_TO_ONE,
        DYNAMIC_ONE_TO_MANY;

    }
}

