/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import java.util.List;
import java.util.Optional;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.CypherAdapterUtils;
import org.springframework.data.neo4j.repository.support.Neo4jEntityInformation;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
@API(status=API.Status.STABLE, since="6.0")
public class SimpleNeo4jRepository<T, ID>
implements PagingAndSortingRepository<T, ID> {
    private final Neo4jOperations neo4jOperations;
    private final Neo4jEntityInformation<T, ID> entityInformation;
    private final Neo4jPersistentEntity<T> entityMetaData;
    private final CypherGenerator cypherGenerator;

    protected SimpleNeo4jRepository(Neo4jOperations neo4jOperations, Neo4jEntityInformation<T, ID> entityInformation) {
        this.neo4jOperations = neo4jOperations;
        this.entityInformation = entityInformation;
        this.entityMetaData = this.entityInformation.getEntityMetaData();
        this.cypherGenerator = CypherGenerator.INSTANCE;
    }

    public Optional<T> findById(ID id) {
        return this.neo4jOperations.findById(id, this.entityInformation.getJavaType());
    }

    public List<T> findAllById(Iterable<ID> ids) {
        return this.neo4jOperations.findAllById(ids, this.entityInformation.getJavaType());
    }

    public List<T> findAll() {
        return this.neo4jOperations.findAll(this.entityInformation.getJavaType());
    }

    public List<T> findAll(Sort sort) {
        Statement statement = this.cypherGenerator.prepareMatchOf(this.entityMetaData).returning(this.cypherGenerator.createReturnStatementForMatch(this.entityMetaData)).orderBy(CypherAdapterUtils.toSortItems(this.entityMetaData, sort)).build();
        return this.neo4jOperations.findAll(statement, this.entityInformation.getJavaType());
    }

    public Page<T> findAll(Pageable pageable) {
        StatementBuilder.OngoingReadingAndReturn returning = this.cypherGenerator.prepareMatchOf(this.entityMetaData).returning(this.cypherGenerator.createReturnStatementForMatch(this.entityMetaData));
        StatementBuilder.BuildableStatement returningWithPaging = CypherAdapterUtils.addPagingParameter(this.entityMetaData, pageable, returning);
        Statement statement = returningWithPaging.build();
        List allResult = this.neo4jOperations.findAll(statement, this.entityInformation.getJavaType());
        LongSupplier totalCountSupplier = this::count;
        return PageableExecutionUtils.getPage(allResult, (Pageable)pageable, (LongSupplier)totalCountSupplier);
    }

    public long count() {
        return this.neo4jOperations.count(this.entityInformation.getJavaType());
    }

    public boolean existsById(ID id) {
        return this.findById(id).isPresent();
    }

    @Transactional
    public <S extends T> S save(S entity) {
        return this.neo4jOperations.save(entity);
    }

    @Transactional
    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        return this.neo4jOperations.saveAll(entities);
    }

    @Transactional
    public void deleteById(ID id) {
        this.neo4jOperations.deleteById(id, this.entityInformation.getJavaType());
    }

    @Transactional
    public void delete(T entity) {
        Object id = this.entityInformation.getId(entity);
        if (this.entityMetaData.hasVersionProperty()) {
            Neo4jPersistentProperty versionProperty = (Neo4jPersistentProperty)this.entityMetaData.getRequiredVersionProperty();
            Object versionValue = this.entityMetaData.getPropertyAccessor(entity).getProperty((PersistentProperty)versionProperty);
            this.neo4jOperations.deleteByIdWithVersion(id, this.entityInformation.getJavaType(), versionProperty, versionValue);
        } else {
            this.deleteById(id);
        }
    }

    @Transactional
    public void deleteAll() {
        this.neo4jOperations.deleteAll(this.entityInformation.getJavaType());
    }

    @Transactional
    public void deleteAll(Iterable<? extends T> entities) {
        List ids = StreamSupport.stream(entities.spliterator(), false).map(arg_0 -> this.entityInformation.getId(arg_0)).collect(Collectors.toList());
        this.neo4jOperations.deleteAllById(ids, this.entityInformation.getJavaType());
    }
}

