/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Conditions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.repository.query.CypherAdapterUtils;
import org.springframework.data.neo4j.repository.query.Predicate;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0.4")
public final class QueryFragmentsAndParameters {
    private static final CypherGenerator cypherGenerator = CypherGenerator.INSTANCE;
    private Map<String, Object> parameters;
    private NodeDescription<?> nodeDescription;
    private final QueryFragments queryFragments;
    private final String cypherQuery;

    public QueryFragmentsAndParameters(NodeDescription<?> nodeDescription, QueryFragments queryFragments, Map<String, Object> parameters) {
        this.nodeDescription = nodeDescription;
        this.queryFragments = queryFragments;
        this.parameters = parameters;
        this.cypherQuery = null;
    }

    public QueryFragmentsAndParameters(String cypherQuery) {
        this.cypherQuery = cypherQuery;
        this.queryFragments = new QueryFragments();
        this.parameters = null;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public QueryFragments getQueryFragments() {
        return this.queryFragments;
    }

    public String getCypherQuery() {
        return this.cypherQuery;
    }

    public NodeDescription<?> getNodeDescription() {
        return this.nodeDescription;
    }

    public void setParameters(Map<String, Object> newParameters) {
        this.parameters = newParameters;
    }

    public static QueryFragmentsAndParameters forFindById(Neo4jPersistentEntity<?> entityMetaData, Object idValues) {
        Map<String, Object> parameters = Collections.singletonMap("__id__", idValues);
        Condition condition = entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)"__id__"));
        Expression[] returnStatement = cypherGenerator.createReturnStatementForMatch(entityMetaData);
        QueryFragments queryFragments = new QueryFragments();
        queryFragments.addMatchOn((PatternElement)cypherGenerator.createRootNode(entityMetaData));
        queryFragments.setCondition(condition);
        queryFragments.setReturnExpression(returnStatement);
        return new QueryFragmentsAndParameters(entityMetaData, queryFragments, parameters);
    }

    public static QueryFragmentsAndParameters forFindByAllId(Neo4jPersistentEntity<?> entityMetaData, Object idValues) {
        Map<String, Object> parameters = Collections.singletonMap("__ids__", idValues);
        Condition condition = entityMetaData.getIdExpression().in((Expression)Cypher.parameter((String)"__ids__"));
        Expression[] returnStatement = cypherGenerator.createReturnStatementForMatch(entityMetaData);
        QueryFragments queryFragments = new QueryFragments();
        queryFragments.addMatchOn((PatternElement)cypherGenerator.createRootNode(entityMetaData));
        queryFragments.setCondition(condition);
        queryFragments.setReturnExpression(returnStatement);
        return new QueryFragmentsAndParameters(entityMetaData, queryFragments, parameters);
    }

    public static QueryFragmentsAndParameters forFindAll(Neo4jPersistentEntity<?> entityMetaData) {
        QueryFragments queryFragments = new QueryFragments();
        queryFragments.addMatchOn((PatternElement)cypherGenerator.createRootNode(entityMetaData));
        queryFragments.setCondition(Conditions.noCondition());
        queryFragments.setReturnExpression(cypherGenerator.createReturnStatementForMatch(entityMetaData));
        return new QueryFragmentsAndParameters(entityMetaData, queryFragments, Collections.emptyMap());
    }

    static QueryFragmentsAndParameters forExample(Neo4jMappingContext mappingContext, Example<?> example) {
        return QueryFragmentsAndParameters.forExample(mappingContext, example, null, null);
    }

    static QueryFragmentsAndParameters forExample(Neo4jMappingContext mappingContext, Example<?> example, Sort sort) {
        return QueryFragmentsAndParameters.forExample(mappingContext, example, null, sort);
    }

    static QueryFragmentsAndParameters forExample(Neo4jMappingContext mappingContext, Example<?> example, Pageable pageable) {
        return QueryFragmentsAndParameters.forExample(mappingContext, example, pageable, null);
    }

    static QueryFragmentsAndParameters forExample(Neo4jMappingContext mappingContext, Example<?> example, @Nullable Pageable pageable, @Nullable Sort sort) {
        Predicate predicate = Predicate.create(mappingContext, example);
        Map<String, Object> parameters = predicate.getParameters();
        Condition condition = predicate.getCondition();
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)mappingContext.getPersistentEntity(example.getProbeType());
        Expression[] returnStatement = cypherGenerator.createReturnStatementForMatch(entityMetaData);
        QueryFragments queryFragments = new QueryFragments();
        queryFragments.addMatchOn((PatternElement)cypherGenerator.createRootNode(entityMetaData));
        queryFragments.setCondition(condition);
        queryFragments.setReturnExpression(returnStatement);
        if (pageable != null) {
            Sort pageableSort = pageable.getSort();
            long skip = pageable.getOffset();
            int pageSize = pageable.getPageSize();
            queryFragments.setSkip(skip);
            queryFragments.setLimit(pageSize);
            queryFragments.setOrderBy(CypherAdapterUtils.toSortItems(entityMetaData, pageableSort));
        } else if (sort != null) {
            queryFragments.setOrderBy(CypherAdapterUtils.toSortItems(entityMetaData, sort));
        }
        return new QueryFragmentsAndParameters(entityMetaData, queryFragments, parameters);
    }

    @API(status=API.Status.INTERNAL, since="6.0.4")
    public static final class QueryFragments {
        private List<PatternElement> matchOn = new ArrayList<PatternElement>();
        private Condition condition;
        private List<Expression> returnExpressions = new ArrayList<Expression>();
        private SortItem[] orderBy;
        private Number limit;
        private Long skip;
        private ReturnTuple returnTuple;

        public void addMatchOn(PatternElement match) {
            this.matchOn.add(match);
        }

        public void setMatchOn(List<PatternElement> match) {
            this.matchOn = match;
        }

        public List<PatternElement> getMatchOn() {
            return this.matchOn;
        }

        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public void setReturnExpression(Expression[] expression) {
            this.returnExpressions = Arrays.asList(expression);
        }

        public void addReturnExpression(Expression returnExpression) {
            this.returnExpressions.add(returnExpression);
        }

        public void setOrderBy(SortItem[] orderBy) {
            this.orderBy = orderBy;
        }

        public void setLimit(Number limit) {
            this.limit = limit;
        }

        public void setSkip(Long skip) {
            this.skip = skip;
        }

        public void setReturnBasedOn(NodeDescription<?> nodeDescription, List<String> includedProperties) {
            this.returnTuple = new ReturnTuple(nodeDescription, includedProperties);
        }

        public ReturnTuple getReturnTuple() {
            return this.returnTuple;
        }

        private Expression[] getReturnExpressions() {
            return this.returnExpressions.size() > 0 ? this.returnExpressions.toArray(new Expression[0]) : CypherGenerator.INSTANCE.createReturnStatementForMatch(this.getReturnTuple().getNodeDescription(), this.getReturnTuple().getIncludedProperties());
        }

        private SortItem[] getOrderBy() {
            return this.orderBy != null ? this.orderBy : new SortItem[]{};
        }

        public Statement toStatement() {
            StatementBuilder.OngoingReadingWithoutWhere match = null;
            for (PatternElement patternElement : this.matchOn) {
                if (match == null) {
                    match = Cypher.match((PatternElement[])new PatternElement[]{this.matchOn.get(0)});
                    continue;
                }
                match = match.match(new PatternElement[]{patternElement});
            }
            return match.where(this.condition).returning(this.getReturnExpressions()).orderBy(this.getOrderBy()).skip((Number)this.skip).limit(this.limit).build();
        }

        @API(status=API.Status.INTERNAL, since="6.0.4")
        public static final class ReturnTuple {
            private final NodeDescription<?> nodeDescription;
            private final List<String> includedProperties;

            private ReturnTuple(NodeDescription<?> nodeDescription, List<String> includedProperties) {
                this.nodeDescription = nodeDescription;
                this.includedProperties = includedProperties;
            }

            public NodeDescription<?> getNodeDescription() {
                return this.nodeDescription;
            }

            public List<String> getIncludedProperties() {
                return this.includedProperties;
            }
        }
    }
}

