/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.Statement;

final class GenericQueryAndParameters {
    private static final String ROOT_NODE_IDS = "rootNodeIds";
    private static final String RELATIONSHIP_IDS = "relationshipIds";
    private static final String RELATED_NODE_IDS = "relatedNodeIds";
    static final Statement STATEMENT = GenericQueryAndParameters.createStatement();
    static final GenericQueryAndParameters EMPTY = new GenericQueryAndParameters(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    private final Map<String, Collection<Long>> parameters = new HashMap<String, Collection<Long>>(3);

    GenericQueryAndParameters(Collection<Long> rootNodeIds, Collection<Long> relationshipsIds, Collection<Long> relatedNodeIds) {
        this.parameters.put(ROOT_NODE_IDS, rootNodeIds);
        this.parameters.put(RELATIONSHIP_IDS, relationshipsIds);
        this.parameters.put(RELATED_NODE_IDS, relatedNodeIds);
    }

    GenericQueryAndParameters() {
        this(new HashSet<Long>(), new HashSet<Long>(), new HashSet<Long>());
    }

    void with(Collection<Long> rootNodeIds, Collection<Long> relationshipsIds, Collection<Long> relatedNodeIds) {
        this.parameters.put(ROOT_NODE_IDS, rootNodeIds);
        this.parameters.put(RELATIONSHIP_IDS, relationshipsIds);
        this.parameters.put(RELATED_NODE_IDS, relatedNodeIds);
    }

    Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    boolean isEmpty() {
        return this.parameters.get(ROOT_NODE_IDS).isEmpty();
    }

    private static Statement createStatement() {
        Node rootNodes = Cypher.anyNode((String)ROOT_NODE_IDS);
        Node relatedNodes = Cypher.anyNode((String)RELATED_NODE_IDS);
        Relationship relationships = Cypher.anyNode().relationshipBetween(Cypher.anyNode(), new String[0]).named(RELATIONSHIP_IDS);
        return Cypher.match((PatternElement[])new PatternElement[]{rootNodes}).where(Functions.id((Node)rootNodes).in((Expression)Cypher.parameter((String)ROOT_NODE_IDS))).optionalMatch(new PatternElement[]{relationships}).where(Functions.id((Relationship)relationships).in((Expression)Cypher.parameter((String)RELATIONSHIP_IDS))).optionalMatch(new PatternElement[]{relatedNodes}).where(Functions.id((Node)relatedNodes).in((Expression)Cypher.parameter((String)RELATED_NODE_IDS))).returning(new Expression[]{rootNodes.as("__sn__"), Functions.collectDistinct((Named)relationships).as("__sr__"), Functions.collectDistinct((Named)relatedNodes).as("__srn__")}).build();
    }
}

