/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.Type;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;

@API(status=API.Status.INTERNAL, since="6.0")
public final class MappingSupport {
    public static Collection<?> unifyRelationshipValue(Neo4jPersistentProperty property, Object rawValue) {
        Collection<Object> unifiedValue = property.isDynamicAssociation() ? (property.isDynamicOneToManyAssociation() ? (Collection)((Map)rawValue).entrySet().stream().flatMap(e -> ((Collection)e.getValue()).stream().map(v -> new AbstractMap.SimpleEntry(e.getKey(), v))).collect(Collectors.toList()) : ((Map)rawValue).entrySet()) : (property.isRelationshipWithProperties() ? (Set)rawValue : (property.isCollectionLike() ? (Collection)rawValue : Collections.singleton(rawValue)));
        return unifiedValue;
    }

    public static Predicate<Value> isListContainingOnly(Type collectionType, Type requiredType) {
        Predicate<Value> containsOnlyRequiredType = entry -> {
            for (Value listEntry : entry.values()) {
                if (listEntry.hasType(requiredType)) continue;
                return false;
            }
            return true;
        };
        Predicate<Value> isList = entry -> entry.hasType(collectionType);
        return isList.and(containsOnlyRequiredType);
    }

    private MappingSupport() {
    }

    @API(status=API.Status.INTERNAL)
    static final class RelationshipPropertiesWithEntityHolder {
        private final Object relationshipProperties;
        private final Object relatedEntity;

        RelationshipPropertiesWithEntityHolder(Object relationshipProperties, Object relatedEntity) {
            this.relationshipProperties = relationshipProperties;
            this.relatedEntity = relatedEntity;
        }

        Object getRelationshipProperties() {
            return this.relationshipProperties;
        }

        Object getRelatedEntity() {
            return this.relatedEntity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelationshipPropertiesWithEntityHolder that = (RelationshipPropertiesWithEntityHolder)o;
            return this.relationshipProperties.equals(that.relationshipProperties) && this.relatedEntity.equals(that.relatedEntity);
        }

        public int hashCode() {
            return Objects.hash(this.relationshipProperties, this.relatedEntity);
        }
    }
}

