/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.exceptions.NoSuchRecordException;
import org.neo4j.driver.summary.SummaryCounters;
import org.neo4j.driver.types.Entity;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.callback.ReactiveEntityCallbacks;
import org.springframework.data.neo4j.core.DatabaseSelection;
import org.springframework.data.neo4j.core.DynamicLabels;
import org.springframework.data.neo4j.core.GenericQueryAndParameters;
import org.springframework.data.neo4j.core.PreparedQuery;
import org.springframework.data.neo4j.core.ReactiveDatabaseSelectionProvider;
import org.springframework.data.neo4j.core.ReactiveNeo4jClient;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import org.springframework.data.neo4j.core.RelationshipHandler;
import org.springframework.data.neo4j.core.TemplateSupport;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.CreateRelationshipStatementHolder;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NestedRelationshipContext;
import org.springframework.data.neo4j.core.mapping.NestedRelationshipProcessingStateMachine;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.mapping.callback.ReactiveEventSupport;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@API(status=API.Status.STABLE, since="6.0")
public final class ReactiveNeo4jTemplate
implements ReactiveNeo4jOperations,
BeanFactoryAware {
    private static final LogAccessor log = new LogAccessor(LogFactory.getLog(ReactiveNeo4jTemplate.class));
    private static final String OPTIMISTIC_LOCKING_ERROR_MESSAGE = "An entity with the required version does not exist.";
    private static final Renderer renderer = Renderer.getDefaultRenderer();
    private static final String CONTEXT_RELATIONSHIP_HANDLER = "RELATIONSHIP_HANDLER";
    private final ReactiveNeo4jClient neo4jClient;
    private final Neo4jMappingContext neo4jMappingContext;
    private final CypherGenerator cypherGenerator;
    private ReactiveEventSupport eventSupport;
    private final ReactiveDatabaseSelectionProvider databaseSelectionProvider;

    public ReactiveNeo4jTemplate(ReactiveNeo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext, ReactiveDatabaseSelectionProvider databaseSelectionProvider) {
        Assert.notNull((Object)neo4jClient, (String)"The Neo4jClient is required");
        Assert.notNull((Object)neo4jMappingContext, (String)"The Neo4jMappingContext is required");
        Assert.notNull((Object)databaseSelectionProvider, (String)"The database selection provider is required");
        this.neo4jClient = neo4jClient;
        this.neo4jMappingContext = neo4jMappingContext;
        this.cypherGenerator = CypherGenerator.INSTANCE;
        this.eventSupport = ReactiveEventSupport.useExistingCallbacks(neo4jMappingContext, ReactiveEntityCallbacks.create());
        this.databaseSelectionProvider = databaseSelectionProvider;
    }

    @Override
    public Mono<Long> count(Class<?> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData).returning(new Expression[]{Functions.count((Expression)Cypher.asterisk())}).build();
        return this.count(statement);
    }

    @Override
    public Mono<Long> count(Statement statement) {
        return this.count(statement, Collections.emptyMap());
    }

    @Override
    public Mono<Long> count(Statement statement, Map<String, Object> parameters) {
        return this.count(renderer.render(statement), parameters);
    }

    @Override
    public Mono<Long> count(String cypherQuery) {
        return this.count(cypherQuery, Collections.emptyMap());
    }

    @Override
    public Mono<Long> count(String cypherQuery, Map<String, Object> parameters) {
        PreparedQuery<Long> preparedQuery = PreparedQuery.queryFor(Long.class).withCypherQuery(cypherQuery).withParameters(parameters).build();
        return this.toExecutableQuery(preparedQuery).flatMap(ReactiveNeo4jOperations.ExecutableQuery::getSingleResult);
    }

    @Override
    public <T> Flux<T> findAll(Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        return this.createExecutableQuery(domainType, QueryFragmentsAndParameters.forFindAll(entityMetaData)).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Flux<T> findAll(Statement statement, Class<T> domainType) {
        return this.createExecutableQuery(domainType, statement).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Flux<T> findAll(Statement statement, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, statement, parameters).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Mono<T> findOne(Statement statement, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, statement, parameters).flatMap(ReactiveNeo4jOperations.ExecutableQuery::getSingleResult);
    }

    @Override
    public <T> Flux<T> findAll(String cypherQuery, Class<T> domainType) {
        return this.createExecutableQuery(domainType, cypherQuery).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Flux<T> findAll(String cypherQuery, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, cypherQuery, parameters).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Mono<T> findOne(String cypherQuery, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, cypherQuery, parameters).flatMap(ReactiveNeo4jOperations.ExecutableQuery::getSingleResult);
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        return this.createExecutableQuery(domainType, QueryFragmentsAndParameters.forFindById(entityMetaData, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id))).flatMap(ReactiveNeo4jOperations.ExecutableQuery::getSingleResult);
    }

    @Override
    public <T> Flux<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        return this.createExecutableQuery(domainType, QueryFragmentsAndParameters.forFindByAllId(entityMetaData, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), ids))).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> toExecutableQuery(Class<T> domainType, QueryFragmentsAndParameters queryFragmentsAndParameters) {
        return this.createExecutableQuery(domainType, queryFragmentsAndParameters);
    }

    private Object convertIdValues(@Nullable Neo4jPersistentProperty idProperty, Object idValues) {
        if (((Neo4jPersistentEntity)idProperty.getOwner()).isUsingInternalIds()) {
            return idValues;
        }
        return this.neo4jMappingContext.getConversionService().writeValue(idValues, (TypeInformation<?>)ClassTypeInformation.from(idValues.getClass()), idProperty == null ? null : idProperty.getOptionalWritingConverter());
    }

    @Override
    public <T> Mono<T> save(T instance) {
        return this.getDatabaseName().flatMap(databaseName -> this.saveImpl(instance, databaseName.getValue()));
    }

    private <T> Mono<T> saveImpl(T instance, @Nullable String inDatabase) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(instance.getClass());
        boolean isNewEntity = entityMetaData.isNew(instance);
        return Mono.just(instance).flatMap(this.eventSupport::maybeCallBeforeBind).flatMap(entityToBeSaved -> this.determineDynamicLabels(entityToBeSaved, entityMetaData, inDatabase)).flatMap(t -> {
            Object entityToBeSaved = t.getT1();
            DynamicLabels dynamicLabels = (DynamicLabels)t.getT2();
            Statement saveStatement = this.cypherGenerator.prepareSaveOf(entityMetaData, dynamicLabels);
            Mono idMono = ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(saveStatement)).in(inDatabase).bind(entityToBeSaved).with(this.neo4jMappingContext.getRequiredBinderFunctionFor(entityToBeSaved.getClass()))).fetchAs(Entity.class).one().switchIfEmpty(Mono.defer(() -> {
                if (entityMetaData.hasVersionProperty()) {
                    return Mono.error(() -> new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE));
                }
                return Mono.empty();
            }));
            PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(entityToBeSaved);
            return idMono.doOnNext(newOrUpdatedNode -> {
                if (entityMetaData.isUsingInternalIds()) {
                    propertyAccessor.setProperty(entityMetaData.getRequiredIdProperty(), (Object)newOrUpdatedNode.id());
                }
                TemplateSupport.updateVersionPropertyIfPossible(entityMetaData, propertyAccessor, newOrUpdatedNode);
            }).map(Entity::id).flatMap(internalId -> this.processRelations(entityMetaData, instance, (Long)internalId, (PersistentPropertyAccessor<?>)propertyAccessor, inDatabase, isNewEntity));
        });
    }

    private <T> Mono<Tuple2<T, DynamicLabels>> determineDynamicLabels(T entityToBeSaved, Neo4jPersistentEntity<?> entityMetaData, @Nullable String inDatabase) {
        return entityMetaData.getDynamicLabelsProperty().map(p -> {
            PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(entityToBeSaved);
            Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty();
            ReactiveNeo4jClient.RunnableSpecTightToDatabase runnableQuery = (ReactiveNeo4jClient.RunnableSpecTightToDatabase)((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.createStatementReturningDynamicLabels(entityMetaData))).in(inDatabase).bind(this.convertIdValues(idProperty, propertyAccessor.getProperty((PersistentProperty)idProperty))).to("__id__")).bind(entityMetaData.getStaticLabels()).to("__staticLabels__");
            if (entityMetaData.hasVersionProperty()) {
                runnableQuery = (ReactiveNeo4jClient.RunnableSpecTightToDatabase)runnableQuery.bind((Long)propertyAccessor.getProperty(entityMetaData.getRequiredVersionProperty())).to("__version__");
            }
            return runnableQuery.fetch().one().map(m -> (Collection)m.get("__nodeLabels__")).switchIfEmpty(Mono.just(Collections.emptyList())).zipWith(Mono.just((Object)((Collection)propertyAccessor.getProperty((PersistentProperty)p)))).map(t -> Tuples.of((Object)entityToBeSaved, (Object)new DynamicLabels((Collection)t.getT1(), (Collection)t.getT2())));
        }).orElse(Mono.just((Object)Tuples.of(entityToBeSaved, (Object)DynamicLabels.EMPTY)));
    }

    @Override
    public <T> Flux<T> saveAll(Iterable<T> instances) {
        HashSet types = new HashSet();
        ArrayList entities = new ArrayList();
        instances.forEach(instance -> {
            entities.add(instance);
            types.add(instance.getClass());
        });
        if (entities.isEmpty()) {
            return Flux.empty();
        }
        boolean heterogeneousCollection = types.size() > 1;
        Class domainClass = (Class)types.iterator().next();
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainClass);
        if (heterogeneousCollection || entityMetaData.isUsingInternalIds() || entityMetaData.hasVersionProperty() || entityMetaData.getDynamicLabelsProperty().isPresent()) {
            log.debug((CharSequence)"Saving entities using single statements.");
            return this.getDatabaseName().flatMapMany(databaseName -> Flux.fromIterable((Iterable)entities).flatMap(e -> this.saveImpl(e, databaseName.getValue())));
        }
        Function binderFunction = this.neo4jMappingContext.getRequiredBinderFunctionFor(domainClass);
        return this.getDatabaseName().flatMapMany(databaseName -> Flux.fromIterable((Iterable)entities).map(e -> Tuples.of((Object)e, (Object)entityMetaData.isNew(e))).zipWith((Publisher)Flux.fromIterable((Iterable)entities).flatMapSequential(this.eventSupport::maybeCallBeforeBind)).map(nested -> Tuples.of((Object)((Tuple2)nested.getT1()).getT1(), (Object)((Tuple2)nested.getT1()).getT2(), (Object)nested.getT2())).collectList().flatMapMany(entitiesToBeSaved -> Mono.defer(() -> {
            List boundedEntityList = entitiesToBeSaved.stream().map(t -> t.getT3()).map(binderFunction).collect(Collectors.toList());
            return ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.prepareSaveOfMultipleInstancesOf(entityMetaData))).in(databaseName.getValue()).bind(boundedEntityList).to("__entities__")).run();
        }).doOnNext(resultSummary -> {
            SummaryCounters counters = resultSummary.counters();
            log.debug(() -> String.format("Created %d and deleted %d nodes, created %d and deleted %d relationships and set %d properties.", counters.nodesCreated(), counters.nodesDeleted(), counters.relationshipsCreated(), counters.relationshipsDeleted(), counters.propertiesSet()));
        }).thenMany((Publisher)Flux.fromIterable((Iterable)entitiesToBeSaved).flatMap(t -> this.processRelations(entityMetaData, t.getT1(), entityMetaData.getPropertyAccessor(t.getT3()), databaseName.getValue(), (Boolean)t.getT2())))));
    }

    @Override
    public <T> Mono<Void> deleteAllById(Iterable<?> ids, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        String nameOfParameter = "ids";
        Condition condition = entityMetaData.getIdExpression().in((Expression)Cypher.parameter((String)nameOfParameter));
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData, condition);
        return this.getDatabaseName().flatMap(databaseName -> ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(statement)).in(databaseName.getValue()).bind(this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), ids)).to(nameOfParameter)).run().then());
    }

    @Override
    public <T> Mono<Void> deleteById(Object id, Class<T> domainType) {
        Assert.notNull((Object)id, (String)"The given id must not be null!");
        String nameOfParameter = "id";
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Condition condition = entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)nameOfParameter));
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData, condition);
        return this.getDatabaseName().flatMap(databaseName -> ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(statement)).in(databaseName.getValue()).bind(this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id)).to(nameOfParameter)).run().then());
    }

    @Override
    public <T> Mono<Void> deleteByIdWithVersion(Object id, Class<T> domainType, Neo4jPersistentProperty versionProperty, Object versionValue) {
        String nameOfParameter = "id";
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Condition condition = entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)nameOfParameter)).and(Cypher.property((Expression)Constants.NAME_OF_ROOT_NODE, (String[])new String[]{versionProperty.getPropertyName()}).isEqualTo((Expression)Cypher.parameter((String)"__version__")).or(Cypher.property((Expression)Constants.NAME_OF_ROOT_NODE, (String[])new String[]{versionProperty.getPropertyName()}).isNull()));
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData, condition).returning(new Expression[]{Constants.NAME_OF_ROOT_NODE}).build();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(nameOfParameter, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id));
        parameters.put("__version__", versionValue);
        return this.getDatabaseName().flatMap(databaseName -> ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(statement)).in(databaseName.getValue()).bindAll(parameters)).fetch().one().switchIfEmpty(Mono.defer(() -> {
            if (entityMetaData.hasVersionProperty()) {
                return Mono.error(() -> new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE));
            }
            return Mono.empty();
        }))).then(this.deleteById(id, domainType));
    }

    @Override
    public Mono<Void> deleteAll(Class<?> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData);
        return this.getDatabaseName().flatMap(databaseName -> this.neo4jClient.query(() -> renderer.render(statement)).in(databaseName.getValue()).run().then());
    }

    private <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> createExecutableQuery(Class<T> domainType, Statement statement) {
        return this.createExecutableQuery(domainType, renderer.render(statement), Collections.emptyMap());
    }

    private <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> createExecutableQuery(Class<T> domainType, String cypherQuery) {
        return this.createExecutableQuery(domainType, cypherQuery, Collections.emptyMap());
    }

    private <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> createExecutableQuery(Class<T> domainType, Statement statement, Map<String, Object> parameters) {
        return this.createExecutableQuery(domainType, renderer.render(statement), parameters);
    }

    private <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> createExecutableQuery(Class<T> domainType, String cypherQuery, Map<String, Object> parameters) {
        Assert.notNull((Object)this.neo4jMappingContext.getPersistentEntity(domainType), (String)"Cannot get or create persistent entity.");
        PreparedQuery<T> preparedQuery = PreparedQuery.queryFor(domainType).withCypherQuery(cypherQuery).withParameters(parameters).usingMappingFunction(this.neo4jMappingContext.getRequiredMappingFunctionFor(domainType)).build();
        return this.toExecutableQuery(preparedQuery);
    }

    /*
     * Unable to fully structure code
     */
    private <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> createExecutableQuery(Class<T> domainType, QueryFragmentsAndParameters queryFragmentsAndParameters) {
        entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        queryFragments = queryFragmentsAndParameters.getQueryFragments();
        if (entityMetaData == null) ** GOTO lbl-1000
        if (entityMetaData.containsPossibleCircles((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, includeField(java.lang.String ), (Ljava/lang/String;)Z)((QueryFragmentsAndParameters.QueryFragments)queryFragments))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = containsPossibleCircles = false;
        }
        if (containsPossibleCircles && !queryFragments.isScalarValueReturn()) {
            return this.createQueryAndParameters(entityMetaData, queryFragments, queryFragmentsAndParameters.getParameters()).flatMap((Function<GenericQueryAndParameters, Mono>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$createExecutableQuery$35(java.lang.Class org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters$QueryFragments org.springframework.data.neo4j.core.GenericQueryAndParameters ), (Lorg/springframework/data/neo4j/core/GenericQueryAndParameters;)Lreactor/core/publisher/Mono;)((ReactiveNeo4jTemplate)this, domainType, (QueryFragmentsAndParameters.QueryFragments)queryFragments));
        }
        statement = queryFragments.toStatement();
        parameters = new HashMap<String, Object>(queryFragmentsAndParameters.getParameters());
        parameters.putAll(statement.getParameters());
        return this.createExecutableQuery(domainType, ReactiveNeo4jTemplate.renderer.render(statement), parameters);
    }

    private Mono<GenericQueryAndParameters> createQueryAndParameters(Neo4jPersistentEntity<?> entityMetaData, QueryFragmentsAndParameters.QueryFragments queryFragments, Map<String, Object> parameters) {
        return this.getDatabaseName().flatMap(databaseName -> Mono.deferContextual(ctx -> {
            Set rootNodeIds = (Set)ctx.get((Object)"rootNodes");
            Set processedRelationshipIds = (Set)ctx.get((Object)"processedRelationships");
            Set processedNodeIds = (Set)ctx.get((Object)"processedNodes");
            return Flux.fromIterable((Iterable)entityMetaData.getRelationshipsInHierarchy(fieldName -> queryFragments.includeField((String)fieldName))).flatMap(relationshipDescription -> {
                Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData, (RelationshipDescription)relationshipDescription, queryFragments.getMatchOn(), queryFragments.getCondition()).returning(this.cypherGenerator.createReturnStatementForMatch(entityMetaData)).build();
                HashMap<String, Object> usedParameters = new HashMap<String, Object>(parameters);
                usedParameters.putAll(statement.getParameters());
                return ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(statement)).in(databaseName.getValue()).bindAll(usedParameters)).fetch().one().map(record -> {
                    List rootIds = (List)record.get("__sn__");
                    List newRelationshipIds = (List)record.get("__sr__");
                    List newRelatedNodeIds = (List)record.get("__srn__");
                    rootNodeIds.addAll(rootIds);
                    return Tuples.of((Object)newRelationshipIds, (Object)newRelatedNodeIds);
                }).expand(this.iterateAndMapNextLevel((RelationshipDescription)relationshipDescription, databaseName.getValue()));
            }).collect(GenericQueryAndParameters::new, (genericQueryAndParameters, _not_used2) -> genericQueryAndParameters.with(rootNodeIds, processedRelationshipIds, processedNodeIds));
        })).contextWrite(ctx -> ctx.put((Object)"rootNodes", ConcurrentHashMap.newKeySet()).put((Object)"processedNodes", ConcurrentHashMap.newKeySet()).put((Object)"processedRelationships", ConcurrentHashMap.newKeySet()));
    }

    private Flux<Tuple2<Collection<Long>, Collection<Long>>> iterateNextLevel(Collection<Long> relatedNodeIds, RelationshipDescription relationshipDescription, String databaseName) {
        NodeDescription<?> target = relationshipDescription.getTarget();
        return Flux.fromIterable(target.getRelationshipsInHierarchy(s -> true)).flatMap(relDe -> {
            Node node = Cypher.anyNode((SymbolicName)Constants.NAME_OF_ROOT_NODE);
            Statement statement = this.cypherGenerator.prepareMatchOf(target, (RelationshipDescription)relDe, null, Functions.id((Node)node).in((Expression)Cypher.parameter((String)"__id__"))).returning(this.cypherGenerator.createGenericReturnStatement()).build();
            return ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(statement)).in(databaseName).bindAll(Collections.singletonMap("__id__", relatedNodeIds))).fetch().one().map(record -> {
                List newRelationshipIds = (List)record.get("__sr__");
                List newRelatedNodeIds = (List)record.get("__srn__");
                return Tuples.of((Object)newRelationshipIds, (Object)newRelatedNodeIds);
            }).expand(object -> this.iterateAndMapNextLevel((RelationshipDescription)relDe, databaseName).apply((Tuple2<Collection<Long>, Collection<Long>>)object));
        });
    }

    @NonNull
    private Function<Tuple2<Collection<Long>, Collection<Long>>, Publisher<Tuple2<Collection<Long>, Collection<Long>>>> iterateAndMapNextLevel(RelationshipDescription relationshipDescription, String databaseName) {
        return newRelationshipAndRelatedNodeIds -> Flux.deferContextual(ctx -> {
            Set relationshipIds = (Set)ctx.get((Object)"processedRelationships");
            Set processedNodeIds = (Set)ctx.get((Object)"processedNodes");
            Collection newRelationshipIds = (Collection)newRelationshipAndRelatedNodeIds.getT1();
            ConcurrentHashMap.KeySetView tmpProcessedRels = ConcurrentHashMap.newKeySet(newRelationshipIds.size());
            tmpProcessedRels.addAll(newRelationshipIds);
            tmpProcessedRels.removeAll(relationshipIds);
            relationshipIds.addAll(newRelationshipIds);
            Collection newRelatedNodeIds = (Collection)newRelationshipAndRelatedNodeIds.getT2();
            ConcurrentHashMap.KeySetView tmpProcessedNodes = ConcurrentHashMap.newKeySet(newRelatedNodeIds.size());
            tmpProcessedNodes.addAll(newRelatedNodeIds);
            tmpProcessedNodes.removeAll(processedNodeIds);
            processedNodeIds.addAll(newRelatedNodeIds);
            if (tmpProcessedRels.isEmpty() && tmpProcessedNodes.isEmpty()) {
                return Mono.empty();
            }
            return this.iterateNextLevel(newRelatedNodeIds, relationshipDescription, databaseName);
        });
    }

    private <T> Mono<T> processRelations(Neo4jPersistentEntity<?> neo4jPersistentEntity, T originalInstance, Long internalId, PersistentPropertyAccessor<?> parentPropertyAccessor, @Nullable String inDatabase, boolean isParentObjectNew) {
        return this.processNestedRelations(neo4jPersistentEntity, parentPropertyAccessor, isParentObjectNew, inDatabase, new NestedRelationshipProcessingStateMachine(originalInstance, internalId));
    }

    private <T> Mono<T> processRelations(Neo4jPersistentEntity<?> neo4jPersistentEntity, T originalInstance, PersistentPropertyAccessor<?> parentPropertyAccessor, @Nullable String inDatabase, boolean isParentObjectNew) {
        return this.processNestedRelations(neo4jPersistentEntity, parentPropertyAccessor, isParentObjectNew, inDatabase, new NestedRelationshipProcessingStateMachine(originalInstance));
    }

    private <T> Mono<T> processNestedRelations(Neo4jPersistentEntity<?> sourceEntity, PersistentPropertyAccessor<?> parentPropertyAccessor, boolean isParentObjectNew, @Nullable String inDatabase, NestedRelationshipProcessingStateMachine stateMachine) {
        Object fromId = parentPropertyAccessor.getProperty(sourceEntity.getRequiredIdProperty());
        ArrayList relationshipDeleteMonos = new ArrayList();
        ArrayList relationshipCreationCreations = new ArrayList();
        sourceEntity.doWithAssociations(association -> {
            Neo4jPersistentProperty idProperty;
            NestedRelationshipContext relationshipContext = NestedRelationshipContext.of((Association<Neo4jPersistentProperty>)association, parentPropertyAccessor, sourceEntity);
            Object rawValue = relationshipContext.getValue();
            Collection<?> relatedValuesToStore = MappingSupport.unifyRelationshipValue(relationshipContext.getInverse(), rawValue);
            RelationshipDescription relationshipDescription = relationshipContext.getRelationship();
            if (!relationshipDescription.hasInternalIdProperty()) {
                idProperty = null;
            } else {
                Neo4jPersistentEntity relationshipPropertiesEntity = (Neo4jPersistentEntity)relationshipDescription.getRelationshipPropertiesEntity();
                idProperty = (Neo4jPersistentProperty)relationshipPropertiesEntity.getIdProperty();
            }
            NestedRelationshipProcessingStateMachine.ProcessState processState = stateMachine.getStateOf(fromId, relationshipDescription, relatedValuesToStore);
            if (processState == NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_ALL_RELATIONSHIPS || processState == NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_BOTH) {
                return;
            }
            if (!isParentObjectNew && !stateMachine.hasProcessedRelationship(fromId, relationshipDescription)) {
                ArrayList<Long> knownRelationshipsIds = new ArrayList<Long>();
                if (idProperty != null) {
                    for (Object relatedValueToStore2 : relatedValuesToStore) {
                        Long id;
                        if (relatedValueToStore2 == null || (id = (Long)relationshipContext.getRelationshipPropertiesPropertyAccessor(relatedValueToStore2).getProperty((PersistentProperty)idProperty)) == null) continue;
                        knownRelationshipsIds.add(id);
                    }
                }
                Statement relationshipRemoveQuery = this.cypherGenerator.prepareDeleteOf(sourceEntity, relationshipDescription);
                relationshipDeleteMonos.add(((ReactiveNeo4jClient.RunnableSpecTightToDatabase)((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(relationshipRemoveQuery)).in(inDatabase).bind(this.convertIdValues((Neo4jPersistentProperty)sourceEntity.getIdProperty(), fromId)).to("fromId")).bind(knownRelationshipsIds).to("__knownRelationShipIds__")).run().checkpoint("delete relationships").then());
            }
            if (relationshipContext.inverseValueIsEmpty()) {
                return;
            }
            Neo4jPersistentProperty relationshipProperty = (Neo4jPersistentProperty)association.getInverse();
            stateMachine.markRelationshipAsProcessed(fromId, relationshipDescription);
            Flux relationshipCreation = Flux.fromIterable(relatedValuesToStore).concatMap(relatedValueToStore -> {
                Object relatedObjectBeforeCallbacksApplied = relationshipContext.identifyAndExtractRelationshipTargetNode(relatedValueToStore);
                return Mono.deferContextual(ctx -> this.eventSupport.maybeCallBeforeBind(relatedObjectBeforeCallbacksApplied).flatMap(newRelatedObject -> {
                    Neo4jPersistentEntity targetEntity = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(relatedObjectBeforeCallbacksApplied.getClass());
                    long noVersion = Long.MIN_VALUE;
                    Mono queryOrSave = stateMachine.hasProcessedValue(relatedValueToStore) ? Mono.just((Object)stateMachine.getInternalId(relatedObjectBeforeCallbacksApplied)).map(id -> Tuples.of((Object)id, (Object)noVersion)) : this.saveRelatedNode(newRelatedObject, targetEntity, inDatabase).map(entity -> Tuples.of((Object)entity.id(), (Object)(targetEntity.hasVersionProperty() ? entity.get(((Neo4jPersistentProperty)targetEntity.getVersionProperty()).getPropertyName()).asLong() : noVersion)));
                    return queryOrSave.flatMap(idAndVersion -> {
                        long relatedInternalId = (Long)idAndVersion.getT1();
                        stateMachine.markValueAsProcessed(relatedValueToStore, relatedInternalId);
                        PersistentPropertyAccessor targetPropertyAccessor = targetEntity.getPropertyAccessor(newRelatedObject);
                        if (targetEntity.isUsingInternalIds()) {
                            targetPropertyAccessor.setProperty(targetEntity.getRequiredIdProperty(), (Object)relatedInternalId);
                            stateMachine.markValueAsProcessedAs(newRelatedObject, targetPropertyAccessor.getBean());
                        }
                        if (targetEntity.hasVersionProperty() && (Long)idAndVersion.getT2() != noVersion) {
                            targetPropertyAccessor.setProperty(targetEntity.getVersionProperty(), idAndVersion.getT2());
                        }
                        stateMachine.markRelationshipAsProcessed(relatedInternalId, relationshipDescription.getRelationshipObverse());
                        Object idValue = idProperty != null ? relationshipContext.getRelationshipPropertiesPropertyAccessor(relatedValueToStore).getProperty((PersistentProperty)idProperty) : null;
                        boolean isNewRelationship = idValue == null;
                        CreateRelationshipStatementHolder statementHolder = this.neo4jMappingContext.createStatement(sourceEntity, relationshipContext, relatedValueToStore, isNewRelationship);
                        return ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)((ReactiveNeo4jClient.RunnableSpecTightToDatabase)((ReactiveNeo4jClient.RunnableSpecTightToDatabase)((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(statementHolder.getStatement())).in(inDatabase).bind(this.convertIdValues((Neo4jPersistentProperty)sourceEntity.getRequiredIdProperty(), fromId)).to("fromId")).bind(relatedInternalId).to("toId")).bind(idValue).to("__knownRelationShipId__")).bindAll(statementHolder.getProperties())).fetchAs(Long.class).one().flatMap(relationshipInternalId -> {
                            if (idProperty != null && isNewRelationship) {
                                relationshipContext.getRelationshipPropertiesPropertyAccessor(relatedValueToStore).setProperty((PersistentProperty)idProperty, relationshipInternalId);
                            }
                            Mono nestedRelationshipsSignal = null;
                            if (processState != NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_ALL_VALUES) {
                                nestedRelationshipsSignal = this.processNestedRelations(targetEntity, targetPropertyAccessor, targetEntity.isNew(newRelatedObject), inDatabase, stateMachine);
                            }
                            Mono getRelationshipOrRelationshipPropertiesObject = Mono.fromSupplier(() -> MappingSupport.getRelationshipOrRelationshipPropertiesObject(this.neo4jMappingContext, relationshipDescription.hasRelationshipProperties(), relationshipProperty.isDynamicAssociation(), relatedValueToStore, targetPropertyAccessor));
                            return nestedRelationshipsSignal == null ? getRelationshipOrRelationshipPropertiesObject : nestedRelationshipsSignal.then(getRelationshipOrRelationshipPropertiesObject);
                        });
                    }).doOnNext(potentiallyRecreatedRelatedObject -> {
                        RelationshipHandler handler = (RelationshipHandler)ctx.get((Object)CONTEXT_RELATIONSHIP_HANDLER);
                        handler.handle(relatedValueToStore, relatedObjectBeforeCallbacksApplied, potentiallyRecreatedRelatedObject);
                    });
                }).then(Mono.fromSupplier(() -> (RelationshipHandler)ctx.get((Object)CONTEXT_RELATIONSHIP_HANDLER))));
            }).contextWrite(ctx -> {
                RelationshipHandler relationshipHandler = RelationshipHandler.forProperty(relationshipProperty, rawValue);
                return ctx.put((Object)CONTEXT_RELATIONSHIP_HANDLER, (Object)relationshipHandler);
            });
            relationshipCreationCreations.add(relationshipCreation);
        });
        return Flux.concat(relationshipDeleteMonos).thenMany((Publisher)Flux.concat(relationshipCreationCreations)).doOnNext(objects -> objects.applyFinalResultToOwner(parentPropertyAccessor)).checkpoint().then(Mono.fromSupplier(() -> parentPropertyAccessor.getBean()));
    }

    private <Y> Mono<Long> queryRelatedNode(Object entity, Neo4jPersistentEntity<?> targetNodeDescription, @Nullable String inDatabase) {
        Neo4jPersistentProperty requiredIdProperty = (Neo4jPersistentProperty)targetNodeDescription.getRequiredIdProperty();
        PersistentPropertyAccessor targetPropertyAccessor = targetNodeDescription.getPropertyAccessor(entity);
        Object idValue = targetPropertyAccessor.getProperty((PersistentProperty)requiredIdProperty);
        return ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.prepareMatchOf(targetNodeDescription, targetNodeDescription.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)"__id__"))).returning(new String[]{"__internalNeo4jId__"}).build())).in(inDatabase).bindAll(Collections.singletonMap("__id__", idValue))).fetchAs(Long.class).one();
    }

    private <Y> Mono<Entity> saveRelatedNode(Object relatedNode, Neo4jPersistentEntity<?> targetNodeDescription, @Nullable String inDatabase) {
        return this.determineDynamicLabels(relatedNode, targetNodeDescription, inDatabase).flatMap(t -> {
            Object entity = t.getT1();
            Class entityType = targetNodeDescription.getType();
            DynamicLabels dynamicLabels = (DynamicLabels)t.getT2();
            return ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.prepareSaveOf(targetNodeDescription, dynamicLabels))).in(inDatabase).bind(entity).with(this.neo4jMappingContext.getRequiredBinderFunctionFor(entityType))).fetchAs(Entity.class).one();
        }).switchIfEmpty(Mono.defer(() -> {
            if (targetNodeDescription.hasVersionProperty()) {
                return Mono.error(() -> new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE));
            }
            return Mono.empty();
        }));
    }

    private Mono<DatabaseSelection> getDatabaseName() {
        return this.databaseSelectionProvider.getDatabaseSelection().switchIfEmpty(Mono.just((Object)DatabaseSelection.undecided()));
    }

    @Override
    public <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> toExecutableQuery(PreparedQuery<T> preparedQuery) {
        return this.getDatabaseName().flatMap(arg_0 -> this.lambda$toExecutableQuery$70(preparedQuery, arg_0));
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.eventSupport = ReactiveEventSupport.discoverCallbacks(this.neo4jMappingContext, beanFactory);
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ Mono lambda$toExecutableQuery$70(PreparedQuery preparedQuery, DatabaseSelection databaseName) {
        resultType = preparedQuery.getResultType();
        queryFragmentsAndParameters = preparedQuery.getQueryFragmentsAndParameters();
        cypherQuery = queryFragmentsAndParameters.getCypherQuery();
        finalParameters = preparedQuery.getQueryFragmentsAndParameters().getParameters();
        queryFragments = queryFragmentsAndParameters.getQueryFragments();
        entityMetaData = (Neo4jPersistentEntity)queryFragmentsAndParameters.getNodeDescription();
        if (entityMetaData == null) ** GOTO lbl-1000
        if (entityMetaData.containsPossibleCircles((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, includeField(java.lang.String ), (Ljava/lang/String;)Z)((QueryFragmentsAndParameters.QueryFragments)queryFragments))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = containsPossibleCircles = false;
        }
        if (cypherQuery == null || containsPossibleCircles) {
            parameters = queryFragmentsAndParameters.getParameters();
            if (containsPossibleCircles && !queryFragments.isScalarValueReturn()) {
                return this.createQueryAndParameters(entityMetaData, queryFragments, parameters).map((Function<GenericQueryAndParameters, DefaultReactiveExecutableQuery>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$null$68(org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters$QueryFragments org.springframework.data.neo4j.core.DatabaseSelection java.lang.Class org.springframework.data.neo4j.core.PreparedQuery org.springframework.data.neo4j.core.GenericQueryAndParameters ), (Lorg/springframework/data/neo4j/core/GenericQueryAndParameters;)Lorg/springframework/data/neo4j/core/ReactiveNeo4jTemplate$DefaultReactiveExecutableQuery;)((ReactiveNeo4jTemplate)this, (QueryFragmentsAndParameters.QueryFragments)queryFragments, (DatabaseSelection)databaseName, resultType, (PreparedQuery)preparedQuery));
            }
            statement = queryFragments.toStatement();
            cypherQuery = ReactiveNeo4jTemplate.renderer.render(statement);
            finalParameters = new HashMap<String, Object>(finalParameters);
            finalParameters.putAll(statement.getParameters());
        }
        mappingSpec = ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(cypherQuery).in(databaseName.getValue()).bindAll(finalParameters)).fetchAs(resultType);
        fetchSpec = preparedQuery.getOptionalMappingFunction().map((Function<BiFunction, ReactiveNeo4jClient.RecordFetchSpec>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$null$69(org.springframework.data.neo4j.core.ReactiveNeo4jClient$MappingSpec java.util.function.BiFunction ), (Ljava/util/function/BiFunction;)Lorg/springframework/data/neo4j/core/ReactiveNeo4jClient$RecordFetchSpec;)(mappingSpec)).orElse(mappingSpec);
        return Mono.just(new DefaultReactiveExecutableQuery<T>(preparedQuery, fetchSpec));
    }

    private static /* synthetic */ ReactiveNeo4jClient.RecordFetchSpec lambda$null$69(ReactiveNeo4jClient.MappingSpec mappingSpec, BiFunction mappingFunction) {
        return mappingSpec.mappedBy(mappingFunction);
    }

    private /* synthetic */ DefaultReactiveExecutableQuery lambda$null$68(QueryFragmentsAndParameters.QueryFragments queryFragments, DatabaseSelection databaseName, Class resultType, PreparedQuery preparedQuery, GenericQueryAndParameters genericQueryAndParameters) {
        ReactiveNeo4jClient.MappingSpec mappingSpec = ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(queryFragments.generateGenericStatement())).in(databaseName.getValue()).bindAll(genericQueryAndParameters.getParameters())).fetchAs(resultType);
        ReactiveNeo4jClient.RecordFetchSpec fetchSpec = preparedQuery.getOptionalMappingFunction().map(mappingFunction -> mappingSpec.mappedBy(mappingFunction)).orElse(mappingSpec);
        return new DefaultReactiveExecutableQuery(preparedQuery, fetchSpec);
    }

    private /* synthetic */ Mono lambda$createExecutableQuery$35(Class domainType, QueryFragmentsAndParameters.QueryFragments queryFragments, GenericQueryAndParameters finalQueryAndParameters) {
        return this.createExecutableQuery(domainType, renderer.render(queryFragments.generateGenericStatement()), finalQueryAndParameters.getParameters());
    }

    final class DefaultReactiveExecutableQuery<T>
    implements ReactiveNeo4jOperations.ExecutableQuery<T> {
        private final PreparedQuery<T> preparedQuery;
        private final ReactiveNeo4jClient.RecordFetchSpec<T> fetchSpec;

        DefaultReactiveExecutableQuery(PreparedQuery<T> preparedQuery, ReactiveNeo4jClient.RecordFetchSpec<T> fetchSpec) {
            this.preparedQuery = preparedQuery;
            this.fetchSpec = fetchSpec;
        }

        @Override
        public Flux<T> getResults() {
            return this.fetchSpec.all().switchOnFirst((signal, f) -> {
                if (signal.hasValue() && this.preparedQuery.resultsHaveBeenAggregated()) {
                    return f.flatMap(nested -> Flux.fromIterable((Iterable)((Collection)nested)).distinct()).distinct();
                }
                return f;
            });
        }

        @Override
        public Mono<T> getSingleResult() {
            try {
                return this.fetchSpec.one().map(t -> {
                    if (t instanceof LinkedHashSet) {
                        return ((LinkedHashSet)t).iterator().next();
                    }
                    return t;
                });
            }
            catch (NoSuchRecordException e) {
                throw new IncorrectResultSizeDataAccessException(e.getMessage(), 1);
            }
        }
    }
}

