/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.core.CollectionFactory;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.neo4j.core.convert.Neo4jConversionService;
import org.springframework.data.neo4j.core.mapping.Neo4jEntityConverter;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescriptionAndLabels;
import org.springframework.data.neo4j.core.mapping.NodeDescriptionStore;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.schema.TargetNode;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class DefaultNeo4jEntityConverter
implements Neo4jEntityConverter {
    private static final LogAccessor log = new LogAccessor(LogFactory.getLog(DefaultNeo4jEntityConverter.class));
    private final EntityInstantiators entityInstantiators;
    private final NodeDescriptionStore nodeDescriptionStore;
    private final Neo4jConversionService conversionService;
    private TypeSystem typeSystem;

    DefaultNeo4jEntityConverter(EntityInstantiators entityInstantiators, Neo4jConversionService conversionService, NodeDescriptionStore nodeDescriptionStore) {
        Assert.notNull((Object)entityInstantiators, (String)"EntityInstantiators must not be null!");
        Assert.notNull((Object)conversionService, (String)"Neo4jConversionService must not be null!");
        Assert.notNull((Object)nodeDescriptionStore, (String)"NodeDescriptionStore must not be null!");
        this.entityInstantiators = entityInstantiators;
        this.conversionService = conversionService;
        this.nodeDescriptionStore = nodeDescriptionStore;
    }

    public <R> R read(Class<R> targetType, MapAccessor mapAccessor) {
        Neo4jPersistentEntity rootNodeDescription = (Neo4jPersistentEntity)this.nodeDescriptionStore.getNodeDescription(targetType);
        try {
            List<Value> recordValues = mapAccessor instanceof Value && ((Value)mapAccessor).hasType(this.typeSystem.NODE()) ? Collections.singletonList((Value)mapAccessor) : mapAccessor.values();
            String nodeLabel = rootNodeDescription.getPrimaryLabel();
            Value queryRoot = null;
            for (Value value : recordValues) {
                if (!value.hasType(this.typeSystem.NODE()) || !value.asNode().hasLabel(nodeLabel)) continue;
                if (mapAccessor.size() > 1) {
                    queryRoot = DefaultNeo4jEntityConverter.mergeRootNodeWithRecord(value.asNode(), mapAccessor);
                    break;
                }
                queryRoot = value.asNode();
                break;
            }
            if (queryRoot == null) {
                for (Value value : recordValues) {
                    if (!value.hasType(this.typeSystem.MAP())) continue;
                    queryRoot = value;
                    break;
                }
            }
            if (queryRoot == null) {
                throw new MappingException(String.format("Could not find mappable nodes or relationships inside %s for %s", mapAccessor, rootNodeDescription));
            }
            return (R)this.map((MapAccessor)queryRoot, (MapAccessor)queryRoot, rootNodeDescription, new KnownObjects(), (Set<Path.Segment>)new HashSet<Path.Segment>());
        }
        catch (Exception e) {
            throw new MappingException("Error mapping " + mapAccessor.toString(), (Throwable)e);
        }
    }

    private Collection<String> createDynamicLabelsProperty(TypeInformation<?> type, Collection<String> dynamicLabels) {
        Collection target = CollectionFactory.createCollection((Class)type.getType(), String.class, (int)dynamicLabels.size());
        target.addAll(dynamicLabels);
        return target;
    }

    public void write(Object source, Map<String, Object> parameters) {
        HashMap properties = new HashMap();
        Neo4jPersistentEntity nodeDescription = (Neo4jPersistentEntity)this.nodeDescriptionStore.getNodeDescription(source.getClass());
        PersistentPropertyAccessor propertyAccessor = nodeDescription.getPropertyAccessor(source);
        nodeDescription.doWithProperties(p -> {
            if (p.isInternalIdProperty() || p.isDynamicLabels() || p.isEntity()) {
                return;
            }
            Value value = this.conversionService.writeValue(propertyAccessor.getProperty(p), p.getTypeInformation(), p.getOptionalWritingConverter());
            if (p.isComposite()) {
                value.keys().forEach(k -> properties.put(k, value.get(k)));
            } else {
                properties.put(p.getPropertyName(), value);
            }
        });
        parameters.put("__properties__", properties);
        if (nodeDescription.hasIdProperty()) {
            Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)nodeDescription.getRequiredIdProperty();
            parameters.put("__id__", this.conversionService.writeValue(propertyAccessor.getProperty((PersistentProperty)idProperty), idProperty.getTypeInformation(), idProperty.getOptionalWritingConverter()));
        }
        if (nodeDescription.hasVersionProperty()) {
            Long versionProperty = (Long)propertyAccessor.getProperty(nodeDescription.getRequiredVersionProperty());
            parameters.put("__version__", versionProperty - 1L);
        }
    }

    void setTypeSystem(TypeSystem typeSystem) {
        this.typeSystem = typeSystem;
    }

    private static MapAccessor mergeRootNodeWithRecord(Node node, MapAccessor record) {
        HashMap<String, Long> mergedAttributes = new HashMap<String, Long>(node.size() + record.size() + 1);
        mergedAttributes.put("__internalNeo4jId__", node.id());
        mergedAttributes.putAll(node.asMap(Function.identity()));
        mergedAttributes.putAll(record.asMap(Function.identity()));
        return Values.value(mergedAttributes);
    }

    private <ET> ET map(MapAccessor queryResult, MapAccessor allValues, Neo4jPersistentEntity<ET> nodeDescription, KnownObjects knownObjects, Set<Path.Segment> processedSegments) {
        return this.map(queryResult, allValues, nodeDescription, knownObjects, null, processedSegments);
    }

    private <ET> ET map(MapAccessor queryResult, MapAccessor allValues, Neo4jPersistentEntity<ET> nodeDescription, KnownObjects knownObjects, @Nullable Object lastMappedEntity, Set<Path.Segment> processedSegments) {
        Long internalId = this.getInternalId(queryResult);
        Supplier<Object> mappedObjectSupplier = () -> {
            List<String> allLabels = this.getLabels(queryResult);
            NodeDescriptionAndLabels nodeDescriptionAndLabels = NodeDescriptionStore.deriveConcreteNodeDescription(nodeDescription, allLabels);
            Neo4jPersistentEntity concreteNodeDescription = (Neo4jPersistentEntity)nodeDescriptionAndLabels.getNodeDescription();
            Collection relationships = concreteNodeDescription.getRelationships();
            Object instance = this.instantiate(concreteNodeDescription, queryResult, allValues, knownObjects, relationships, nodeDescriptionAndLabels.getDynamicLabels(), lastMappedEntity, processedSegments);
            PersistentPropertyAccessor propertyAccessor = concreteNodeDescription.getPropertyAccessor(instance);
            if (concreteNodeDescription.requiresPropertyPopulation()) {
                Predicate<Neo4jPersistentProperty> isConstructorParameter = arg_0 -> ((PreferredConstructor)concreteNodeDescription.getPersistenceConstructor()).isConstructorParameter(arg_0);
                PropertyHandler<Neo4jPersistentProperty> handler = this.populateFrom(queryResult, propertyAccessor, isConstructorParameter, nodeDescriptionAndLabels.getDynamicLabels(), lastMappedEntity);
                concreteNodeDescription.doWithProperties(handler);
                knownObjects.storeObject(internalId, instance);
                concreteNodeDescription.doWithAssociations(this.populateFrom(queryResult, allValues, propertyAccessor, isConstructorParameter, relationships, knownObjects, processedSegments));
            }
            Object bean = propertyAccessor.getBean();
            knownObjects.storeObject(internalId, bean);
            return bean;
        };
        Object mappedObject = knownObjects.getObject(internalId);
        if (mappedObject == null) {
            mappedObject = mappedObjectSupplier.get();
            knownObjects.storeObject(internalId, mappedObject);
        }
        return (ET)mappedObject;
    }

    @Nullable
    private Long getInternalId(@NonNull MapAccessor queryResult) {
        return queryResult instanceof Node ? Long.valueOf(((Node)queryResult).id()) : (queryResult.get("__internalNeo4jId__") == null || queryResult.get("__internalNeo4jId__").isNull() ? null : Long.valueOf(queryResult.get("__internalNeo4jId__").asLong()));
    }

    @NonNull
    private List<String> getLabels(MapAccessor queryResult) {
        Value labelsValue = queryResult.get("__nodeLabels__");
        ArrayList<String> labels = new ArrayList();
        if (!labelsValue.isNull()) {
            labels = labelsValue.asList(Value::asString);
        } else if (queryResult instanceof Node) {
            Node nodeRepresentation = (Node)queryResult;
            nodeRepresentation.labels().forEach(labels::add);
        }
        return labels;
    }

    private <ET> ET instantiate(final Neo4jPersistentEntity<ET> nodeDescription, final MapAccessor values, final MapAccessor allValues, final KnownObjects knownObjects, final Collection<RelationshipDescription> relationships, final Collection<String> surplusLabels, final Object lastMappedEntity, final Set<Path.Segment> processedSegments) {
        ParameterValueProvider<Neo4jPersistentProperty> parameterValueProvider = new ParameterValueProvider<Neo4jPersistentProperty>(){

            public Object getParameterValue(PreferredConstructor.Parameter parameter) {
                Neo4jPersistentProperty matchingProperty = (Neo4jPersistentProperty)nodeDescription.getRequiredPersistentProperty(parameter.getName());
                if (matchingProperty.isRelationship()) {
                    return DefaultNeo4jEntityConverter.this.createInstanceOfRelationships(matchingProperty, values, allValues, knownObjects, relationships, processedSegments).orElse(null);
                }
                if (matchingProperty.isDynamicLabels()) {
                    return DefaultNeo4jEntityConverter.this.createDynamicLabelsProperty(matchingProperty.getTypeInformation(), surplusLabels);
                }
                if (matchingProperty.isEntityInRelationshipWithProperties()) {
                    return lastMappedEntity;
                }
                return DefaultNeo4jEntityConverter.this.conversionService.readValue(DefaultNeo4jEntityConverter.extractValueOf(matchingProperty, values), parameter.getType(), matchingProperty.getOptionalReadingConverter());
            }
        };
        return (ET)this.entityInstantiators.getInstantiatorFor(nodeDescription).createInstance(nodeDescription, (ParameterValueProvider)parameterValueProvider);
    }

    private PropertyHandler<Neo4jPersistentProperty> populateFrom(MapAccessor queryResult, PersistentPropertyAccessor<?> propertyAccessor, Predicate<Neo4jPersistentProperty> isConstructorParameter, Collection<String> surplusLabels, Object targetNode) {
        return property -> {
            if (isConstructorParameter.test((Neo4jPersistentProperty)property)) {
                return;
            }
            if (property.isDynamicLabels()) {
                propertyAccessor.setProperty(property, this.createDynamicLabelsProperty(property.getTypeInformation(), surplusLabels));
            } else if (property.isAnnotationPresent(TargetNode.class)) {
                if (queryResult instanceof Relationship) {
                    propertyAccessor.setProperty(property, targetNode);
                }
            } else {
                propertyAccessor.setProperty(property, this.conversionService.readValue(DefaultNeo4jEntityConverter.extractValueOf(property, queryResult), property.getTypeInformation(), property.getOptionalReadingConverter()));
            }
        };
    }

    private AssociationHandler<Neo4jPersistentProperty> populateFrom(MapAccessor queryResult, MapAccessor allValues, PersistentPropertyAccessor<?> propertyAccessor, Predicate<Neo4jPersistentProperty> isConstructorParameter, Collection<RelationshipDescription> relationshipDescriptions, KnownObjects knownObjects, Set<Path.Segment> processedSegments) {
        return association -> {
            Neo4jPersistentProperty persistentProperty = (Neo4jPersistentProperty)association.getInverse();
            if (isConstructorParameter.test(persistentProperty)) {
                return;
            }
            this.createInstanceOfRelationships(persistentProperty, queryResult, allValues, knownObjects, relationshipDescriptions, processedSegments).ifPresent(value -> propertyAccessor.setProperty((PersistentProperty)persistentProperty, value));
        };
    }

    private Optional<Object> createInstanceOfRelationships(Neo4jPersistentProperty persistentProperty, MapAccessor values, MapAccessor allValues, KnownObjects knownObjects, Collection<RelationshipDescription> relationshipDescriptions, Set<Path.Segment> processedSegments) {
        BiConsumer<String, Object> mappedObjectHandler;
        RelationshipDescription relationshipDescription = relationshipDescriptions.stream().filter(r -> r.getFieldName().equals(persistentProperty.getName())).findFirst().get();
        String relationshipType = relationshipDescription.getType();
        String targetLabel = relationshipDescription.getTarget().getPrimaryLabel();
        Neo4jPersistentEntity genericTargetNodeDescription = (Neo4jPersistentEntity)relationshipDescription.getTarget();
        List<String> allLabels = this.getLabels(values);
        NodeDescriptionAndLabels nodeDescriptionAndLabels = NodeDescriptionStore.deriveConcreteNodeDescription(genericTargetNodeDescription, allLabels);
        Neo4jPersistentEntity concreteTargetNodeDescription = (Neo4jPersistentEntity)nodeDescriptionAndLabels.getNodeDescription();
        ArrayList value = new ArrayList();
        HashMap dynamicValue = new HashMap();
        Function<Object, Object> keyTransformer = persistentProperty.isDynamicAssociation() && persistentProperty.getComponentType().isEnum() ? f -> this.conversionService.convert(f, persistentProperty.getComponentType()) : Function.identity();
        if (persistentProperty.isDynamicOneToManyAssociation()) {
            TypeInformation actualType = persistentProperty.getTypeInformation().getRequiredActualType();
            mappedObjectHandler = (type, mappedObject) -> {
                List bucket = (List)dynamicValue.computeIfAbsent(keyTransformer.apply(type), s -> CollectionFactory.createCollection((Class)actualType.getType(), (Class)persistentProperty.getAssociationTargetType(), (int)values.size()));
                bucket.add(mappedObject);
            };
        } else {
            mappedObjectHandler = persistentProperty.isDynamicAssociation() ? (type, mappedObject) -> dynamicValue.put(keyTransformer.apply(type), mappedObject) : (type, mappedObject) -> value.add(mappedObject);
        }
        Value list = allValues.get(relationshipDescription.generateRelatedNodesCollectionName());
        ArrayList relationshipsAndProperties = new ArrayList();
        boolean isGeneratedPathBased = allValues.containsKey("__paths__");
        Predicate<Value> isList = entry -> this.typeSystem.LIST().isTypeOf(entry);
        if (isGeneratedPathBased) {
            Value internalStartNodeIdValue = values.get("__internalNeo4jId__");
            long startNodeId = internalStartNodeIdValue.asLong();
            Predicate<Value> containsOnlyPaths = entry -> entry.asList(Function.identity()).stream().allMatch(listEntry -> this.typeSystem.PATH().isTypeOf(listEntry));
            List<Path> allPaths = StreamSupport.stream(values.values().spliterator(), false).filter(isList.and(containsOnlyPaths)).flatMap(entry -> entry.asList(Value::asPath).stream()).collect(Collectors.toList());
            List segments = allPaths.stream().flatMap(p -> StreamSupport.stream(p.spliterator(), false)).filter(s -> s.start().id() == startNodeId && (relationshipDescription.isIncoming() ? s.relationship().endNodeId() : s.relationship().startNodeId()) == startNodeId && (s.relationship().hasType(relationshipType) || relationshipDescription.isDynamic()) && s.end().hasLabel(targetLabel)).distinct().collect(Collectors.toList());
            for (Path.Segment segment : segments) {
                if (processedSegments.contains(segment)) continue;
                processedSegments.add(segment);
                Object mappedObject2 = this.map(this.extractNextNodeAndAppendPath(segment.end(), allPaths), allValues, concreteTargetNodeDescription, knownObjects, processedSegments);
                if (relationshipDescription.hasRelationshipProperties()) {
                    Object relationshipProperties = this.map((MapAccessor)segment.relationship(), allValues, (Neo4jPersistentEntity)relationshipDescription.getRelationshipPropertiesEntity(), knownObjects, mappedObject2, processedSegments);
                    relationshipsAndProperties.add(relationshipProperties);
                    mappedObjectHandler.accept(segment.relationship().type(), relationshipProperties);
                    continue;
                }
                mappedObjectHandler.accept(segment.relationship().type(), mappedObject2);
            }
        } else if (Values.NULL.equals((Object)list)) {
            Predicate<Value> containsOnlyRelationships = entry -> entry.asList(Function.identity()).stream().allMatch(listEntry -> this.typeSystem.RELATIONSHIP().isTypeOf(listEntry));
            Predicate<Value> containsOnlyNodes = entry -> entry.asList(Function.identity()).stream().allMatch(listEntry -> this.typeSystem.NODE().isTypeOf(listEntry));
            List allMatchingTypeRelationshipsInResult = StreamSupport.stream(allValues.values().spliterator(), false).filter(isList.and(containsOnlyRelationships)).flatMap(entry -> entry.asList(Value::asRelationship).stream()).filter(r -> r.type().equals(relationshipType) || relationshipDescription.isDynamic()).collect(Collectors.toList());
            List allNodesWithMatchingLabelInResult = StreamSupport.stream(allValues.values().spliterator(), false).filter(isList.and(containsOnlyNodes)).flatMap(entry -> entry.asList(Value::asNode).stream()).filter(n -> n.hasLabel(targetLabel)).collect(Collectors.toList());
            if (allNodesWithMatchingLabelInResult.isEmpty() && allMatchingTypeRelationshipsInResult.isEmpty()) {
                return Optional.empty();
            }
            Function<Relationship, Long> targetIdSelector = relationshipDescription.isIncoming() ? Relationship::startNodeId : Relationship::endNodeId;
            Function<Relationship, Long> sourceIdSelector = relationshipDescription.isIncoming() ? Relationship::endNodeId : Relationship::startNodeId;
            Long sourceNodeId = this.getInternalId(values);
            block1: for (Node possibleValueNode : allNodesWithMatchingLabelInResult) {
                long targetNodeId = possibleValueNode.id();
                for (Relationship possibleRelationship : allMatchingTypeRelationshipsInResult) {
                    if (targetIdSelector.apply(possibleRelationship) != targetNodeId || !sourceIdSelector.apply(possibleRelationship).equals(sourceNodeId)) continue;
                    Object mappedObject3 = this.map((MapAccessor)possibleValueNode, values, concreteTargetNodeDescription, knownObjects, processedSegments);
                    if (relationshipDescription.hasRelationshipProperties()) {
                        Object relationshipProperties = this.map((MapAccessor)possibleRelationship, allValues, (Neo4jPersistentEntity)relationshipDescription.getRelationshipPropertiesEntity(), knownObjects, mappedObject3, processedSegments);
                        relationshipsAndProperties.add(relationshipProperties);
                        mappedObjectHandler.accept(possibleRelationship.type(), relationshipProperties);
                    } else {
                        mappedObjectHandler.accept(possibleRelationship.type(), mappedObject3);
                    }
                    allMatchingTypeRelationshipsInResult.remove(possibleRelationship);
                    continue block1;
                }
            }
        } else {
            for (Value relatedEntity : list.asList(Function.identity())) {
                Object valueEntry = this.map((MapAccessor)relatedEntity, allValues, concreteTargetNodeDescription, knownObjects, processedSegments);
                if (relationshipDescription.hasRelationshipProperties()) {
                    Relationship relatedEntityRelationship = relatedEntity.get("__relationship__").asRelationship();
                    Object relationshipProperties = this.map((MapAccessor)relatedEntityRelationship, allValues, (Neo4jPersistentEntity)relationshipDescription.getRelationshipPropertiesEntity(), knownObjects, valueEntry, processedSegments);
                    relationshipsAndProperties.add(relationshipProperties);
                    mappedObjectHandler.accept(relatedEntity.get("__relationshipType__").asString(), relationshipProperties);
                    continue;
                }
                mappedObjectHandler.accept(relatedEntity.get("__relationshipType__").asString(), valueEntry);
            }
        }
        if (persistentProperty.getTypeInformation().isCollectionLike()) {
            ArrayList returnedValues = relationshipDescription.hasRelationshipProperties() ? relationshipsAndProperties : value;
            Collection target = CollectionFactory.createCollection((Class)persistentProperty.getRawType(), (Class)persistentProperty.getComponentType(), (int)returnedValues.size());
            target.addAll(returnedValues);
            return Optional.of(target);
        }
        if (relationshipDescription.isDynamic()) {
            return Optional.ofNullable(dynamicValue.isEmpty() ? null : dynamicValue);
        }
        if (relationshipDescription.hasRelationshipProperties()) {
            return Optional.ofNullable(relationshipsAndProperties.isEmpty() ? null : (Object)relationshipsAndProperties.get(0));
        }
        return Optional.ofNullable(value.isEmpty() ? null : (Object)value.get(0));
    }

    private MapAccessor extractNextNodeAndAppendPath(Node possibleValueNode, List<Path> allPaths) {
        HashMap<String, Object> newQueryResult = new HashMap<String, Object>(possibleValueNode.asMap());
        newQueryResult.put("__internalNeo4jId__", possibleValueNode.id());
        newQueryResult.put("__nodeLabels__", possibleValueNode.labels());
        newQueryResult.put("__paths__", allPaths);
        return Values.value(newQueryResult);
    }

    private static Value extractValueOf(Neo4jPersistentProperty property, MapAccessor propertyContainer) {
        if (property.isInternalIdProperty()) {
            return propertyContainer instanceof Node ? Values.value((long)((Node)propertyContainer).id()) : propertyContainer.get("__internalNeo4jId__");
        }
        if (property.isComposite()) {
            String prefix = property.computePrefixWithDelimiter();
            if (propertyContainer.containsKey("__allProperties__")) {
                return DefaultNeo4jEntityConverter.extractCompositePropertyValues((MapAccessor)propertyContainer.get("__allProperties__"), prefix);
            }
            return DefaultNeo4jEntityConverter.extractCompositePropertyValues(propertyContainer, prefix);
        }
        String graphPropertyName = property.getPropertyName();
        return propertyContainer.get(graphPropertyName);
    }

    private static Value extractCompositePropertyValues(MapAccessor propertyContainer, String prefix) {
        HashMap hlp = new HashMap(propertyContainer.size());
        propertyContainer.keys().forEach(k -> {
            if (k.startsWith(prefix)) {
                hlp.put(k, propertyContainer.get(k));
            }
        });
        return Values.value(hlp);
    }

    static class KnownObjects {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final Lock read = this.lock.readLock();
        private final Lock write = this.lock.writeLock();
        private final Map<Long, Object> internalIdStore = new HashMap<Long, Object>();

        KnownObjects() {
        }

        private void storeObject(@Nullable Long internalId, Object object) {
            if (internalId == null) {
                return;
            }
            try {
                this.write.lock();
                this.internalIdStore.put(internalId, object);
            }
            finally {
                this.write.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Object getObject(@Nullable Long internalId) {
            if (internalId == null) {
                return null;
            }
            try {
                this.read.lock();
                Object knownEntity = this.internalIdStore.get(internalId);
                if (knownEntity != null) {
                    Object object = knownEntity;
                    return object;
                }
            }
            finally {
                this.read.unlock();
            }
            return null;
        }
    }
}

