/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.bookmark;

import org.aopalliance.aop.Advice;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.data.neo4j.bookmark.BeanFactoryBookmarkOperationAdvisor;
import org.springframework.data.neo4j.bookmark.BookmarkInterceptor;
import org.springframework.data.neo4j.bookmark.BookmarkManager;

@Configuration
public class BookmarkManagementConfiguration {
    @Bean
    @Role(value=2)
    public BeanFactoryBookmarkOperationAdvisor bookmarkAdvisor() {
        BeanFactoryBookmarkOperationAdvisor advisor = new BeanFactoryBookmarkOperationAdvisor();
        advisor.setAdvice((Advice)this.bookmarkInterceptor());
        advisor.setOrder(0);
        return advisor;
    }

    @Bean
    @Role(value=2)
    public BookmarkInterceptor bookmarkInterceptor() {
        return new BookmarkInterceptor();
    }

    @Bean
    @Role(value=2)
    public BookmarkManagerContextValidator bookmarkManagerContextValidator(ObjectProvider<BookmarkManager> bookmarkManagerProvider) {
        return new BookmarkManagerContextValidator(bookmarkManagerProvider);
    }

    static class BookmarkManagerContextValidator
    implements ApplicationListener<ContextRefreshedEvent> {
        private final ObjectProvider<BookmarkManager> bookmarkManagerProvider;

        public BookmarkManagerContextValidator(ObjectProvider<BookmarkManager> bookmarkManagerProvider) {
            this.bookmarkManagerProvider = bookmarkManagerProvider;
        }

        public void onApplicationEvent(ContextRefreshedEvent event) {
            try {
                this.bookmarkManagerProvider.getObject();
            }
            catch (NoSuchBeanDefinitionException e) {
                throw new IllegalStateException("Bookmark management has been enabled via `@EnableBookmarkManagement` but no bean implementing `org.springframework.data.neo4j.bookmark.BookmarkManager` has been provided.\nPreventing the start of the context as all `@UseBookmark` annotated methods would fail. Please provide a bookmark manager.");
            }
        }
    }
}

