/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.config;

import java.util.Collections;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.neo4j.repository.config.Neo4jMappingContextIsNewStrategyFactory;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.data.support.IsNewStrategyFactory;
import org.springframework.util.Assert;

public class Neo4jIsNewAwareAuditingHandler
extends IsNewAwareAuditingHandler {
    private IsNewStrategyFactory isNewStrategyFactory;

    public Neo4jIsNewAwareAuditingHandler(MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext) {
        this(new PersistentEntities(Collections.singletonList(mappingContext)));
    }

    public Neo4jIsNewAwareAuditingHandler(PersistentEntities entities) {
        super(entities);
        this.isNewStrategyFactory = new Neo4jMappingContextIsNewStrategyFactory(entities);
    }

    public void markAudited(Object object) {
        Assert.notNull((Object)object, (String)"Source object must not be null!");
        if (this.isAuditable(object)) {
            IsNewStrategy strategy = this.isNewStrategyFactory.getIsNewStrategy(object.getClass());
            if (strategy.isNew(object)) {
                this.markCreated(object);
            } else {
                this.markModified(object);
            }
        }
    }
}

