/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.transaction;

import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.neo4j.transaction.SessionFactoryUtils;
import org.springframework.data.neo4j.transaction.SessionHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class Neo4jTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
BeanFactoryAware,
InitializingBean {
    private SessionFactory sessionFactory;

    public Neo4jTransactionManager() {
        this.setTransactionSynchronization(1);
    }

    public Neo4jTransactionManager(SessionFactory sessionFactory) {
        this();
        this.sessionFactory = sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.getSessionFactory() == null) {
            this.setSessionFactory((SessionFactory)beanFactory.getBean(SessionFactory.class));
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("'sessionFactory' is required");
        }
    }

    public Object getResourceFactory() {
        return this.getSessionFactory();
    }

    protected Object doGetTransaction() {
        Neo4jTransactionObject txObject = new Neo4jTransactionObject();
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getSessionFactory()));
        if (sessionHolder != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found thread-bound Session [" + sessionHolder.getSession() + "] for Neo4j OGM transaction"));
            }
            txObject.setSessionHolder(sessionHolder, false);
        }
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        return ((Neo4jTransactionObject)transaction).hasTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        Neo4jTransactionObject txObject = (Neo4jTransactionObject)transaction;
        try {
            Session session;
            if (txObject.getSessionHolder() == null || txObject.getSessionHolder().isSynchronizedWithTransaction()) {
                session = this.sessionFactory.openSession();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Opened new Session [" + session + "] for Neo4j OGM transaction"));
                }
                txObject.setSessionHolder(new SessionHolder(session), true);
            }
            session = txObject.getSessionHolder().getSession();
            if (definition.getIsolationLevel() != -1) {
                throw new InvalidIsolationLevelException("Neo4jTransactionManager is not allowed to support custom isolation levels.");
            }
            if (definition.getPropagationBehavior() != 0) {
                throw new IllegalTransactionStateException("Neo4jTransactionManager only supports 'required' propagation.");
            }
            Transaction transactionData = definition.isReadOnly() && txObject.isNewSessionHolder() ? session.beginTransaction(Transaction.Type.READ_ONLY) : session.beginTransaction();
            txObject.setTransactionData(transactionData);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Beginning Transaction [" + transactionData + "] on Session [" + session + "]"));
            }
            if (txObject.isNewSessionHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)txObject.getSessionHolder()));
            }
            if (definition.isReadOnly()) {
                TransactionSynchronizationManager.setCurrentTransactionReadOnly((boolean)true);
            }
            txObject.getSessionHolder().setSynchronizedWithTransaction(true);
        }
        catch (TransactionException ex) {
            this.closeSessionAfterFailedBegin(txObject);
            throw ex;
        }
        catch (Throwable ex) {
            this.closeSessionAfterFailedBegin(txObject);
            throw new CannotCreateTransactionException("Could not open Neo4j Session for transaction", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSessionAfterFailedBegin(Neo4jTransactionObject txObject) {
        if (txObject.isNewSessionHolder()) {
            Session session = txObject.getSessionHolder().getSession();
            try {
                session.getTransaction().rollback();
            }
            catch (Throwable ex) {
                this.logger.debug((Object)"Could not rollback Session after failed transaction begin", ex);
            }
            finally {
                SessionFactoryUtils.closeSession(session);
            }
            txObject.setSessionHolder(null, false);
        }
    }

    protected Object doSuspend(Object transaction) {
        Neo4jTransactionObject txObject = (Neo4jTransactionObject)transaction;
        txObject.setSessionHolder(null, false);
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory()));
        return new SuspendedResourcesHolder(sessionHolder);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        if (TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory())) {
            TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
        }
        TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)resourcesHolder.getSessionHolder()));
    }

    protected void doCommit(DefaultTransactionStatus status) {
        Neo4jTransactionObject txObject = (Neo4jTransactionObject)status.getTransaction();
        Session session = txObject.getSessionHolder().getSession();
        try (Transaction tx = session.getTransaction();){
            if (status.isDebug()) {
                this.logger.debug((Object)("Committing Neo4j OGM transaction [" + tx + "] on Session [" + session + "]"));
            }
            tx.commit();
        }
        catch (RuntimeException ex) {
            DataAccessException dae = SessionFactoryUtils.convertOgmAccessException(ex);
            throw dae != null ? dae : ex;
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        Neo4jTransactionObject txObject = (Neo4jTransactionObject)status.getTransaction();
        Session session = txObject.getSessionHolder().getSession();
        try (Transaction tx = session.getTransaction();){
            if (status.isDebug()) {
                this.logger.debug((Object)("Rolling back Neo4j transaction [" + tx + "] on Session [" + session + "]"));
            }
            tx.rollback();
        }
        catch (RuntimeException ex) {
            DataAccessException dae = SessionFactoryUtils.convertOgmAccessException(ex);
            throw dae != null ? dae : ex;
        }
        finally {
            if (!txObject.isNewSessionHolder()) {
                session.clear();
            }
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        Neo4jTransactionObject txObject = (Neo4jTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting Neo4j OGM transaction on Session [" + txObject.getSessionHolder().getSession() + "] rollback-only"));
        }
        status.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        Transaction rawTransaction;
        Neo4jTransactionObject txObject = (Neo4jTransactionObject)transaction;
        if (txObject.isNewSessionHolder()) {
            TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.getSessionFactory());
        }
        if ((rawTransaction = txObject.getTransactionData()) != null && rawTransaction.status().equals((Object)Transaction.Status.OPEN)) {
            rawTransaction.close();
        }
        if (txObject.isNewSessionHolder()) {
            Session session = txObject.getSessionHolder().getSession();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing Neo4j Session [" + session + "] after transaction"));
            }
            SessionFactoryUtils.closeSession(session);
        } else {
            this.logger.debug((Object)"Not closing pre-bound Neo4j Session after transaction");
        }
        txObject.getSessionHolder().clear();
    }

    private static class SuspendedResourcesHolder {
        private final SessionHolder sessionHolder;

        private SuspendedResourcesHolder(SessionHolder sessionHolder) {
            this.sessionHolder = sessionHolder;
        }

        private SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }
    }

    private static class Neo4jTransactionObject {
        private SessionHolder sessionHolder;
        private boolean newSessionHolder;
        private Transaction transactionData;

        private Neo4jTransactionObject() {
        }

        void setSessionHolder(SessionHolder sessionHolder, boolean newSessionHolder) {
            this.sessionHolder = sessionHolder;
            this.newSessionHolder = newSessionHolder;
        }

        SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        boolean isNewSessionHolder() {
            return this.newSessionHolder;
        }

        boolean hasTransaction() {
            return this.sessionHolder != null && this.sessionHolder.isTransactionActive();
        }

        void setTransactionData(Transaction rawTransaction) {
            this.transactionData = rawTransaction;
            this.sessionHolder.setTransactionActive(true);
        }

        Transaction getTransactionData() {
            return this.transactionData;
        }
    }
}

