/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.exception.MappingException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.annotation.QueryResult;

public class Neo4jPersistentProperty
extends AnnotationBasedPersistentProperty<Neo4jPersistentProperty> {
    private static final Logger logger = LoggerFactory.getLogger(Neo4jPersistentProperty.class);
    private final boolean isIdProperty;

    public Neo4jPersistentProperty(ClassInfo owningClassInfo, Field field, PropertyDescriptor descriptor, PersistentEntity<?, Neo4jPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        super(field, descriptor, owner, simpleTypeHolder);
        if (owningClassInfo == null) {
            logger.warn("Owning ClassInfo is null for field: {} and propertyDescriptor: {}", (Object)field, (Object)descriptor);
        }
        this.isIdProperty = owningClassInfo != null && owningClassInfo.getUnderlyingClass() != null && simpleTypeHolder.isSimpleType(owningClassInfo.getUnderlyingClass()) || owner.getType().isEnum() ? false : Neo4jPersistentProperty.resolveWhetherIdProperty(owningClassInfo, field);
    }

    private static boolean resolveWhetherIdProperty(ClassInfo owningClassInfo, Field field) {
        if (owningClassInfo == null || owningClassInfo.isInterface() || owningClassInfo.annotationsInfo().get(QueryResult.class.getName()) != null || owningClassInfo.isEnum()) {
            return false;
        }
        try {
            return owningClassInfo.getField(owningClassInfo.identityField()).equals(field);
        }
        catch (MappingException noIdentityField) {
            logger.warn("No identity field found for class of type: {} when creating persistent property for field: {}", (Object)owningClassInfo.name(), (Object)field);
            return false;
        }
    }

    public boolean isIdProperty() {
        logger.debug("[property].isIdProperty() returns {}", (Object)this.isIdProperty);
        return this.isIdProperty;
    }

    public boolean isVersionProperty() {
        logger.debug("[property].isVersionProperty() returns false");
        return false;
    }

    public boolean usePropertyAccess() {
        logger.debug("[property].usePropertyAccess() returns false");
        return false;
    }

    public boolean isAssociation() {
        return !this.isTransient() && this.isAnnotationPresent(Relationship.class);
    }

    protected Association<Neo4jPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }
}

