/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.derived.filter;

import java.util.Map;
import org.neo4j.ogm.cypher.function.DistanceComparison;
import org.neo4j.ogm.cypher.function.DistanceFromPoint;
import org.neo4j.ogm.cypher.function.FilterFunction;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.neo4j.repository.query.derived.CypherFilter;
import org.springframework.data.neo4j.repository.query.derived.filter.FunctionAdapter;

public class DistanceComparisonAdapter
implements FunctionAdapter<DistanceFromPoint> {
    private CypherFilter cypherFilter;
    private DistanceComparison distanceComparison = new DistanceComparison();

    public DistanceComparisonAdapter(CypherFilter cypherFilter) {
        this.cypherFilter = cypherFilter;
    }

    public DistanceComparisonAdapter() {
        this(null);
    }

    @Override
    public CypherFilter cypherFilter() {
        return this.cypherFilter;
    }

    @Override
    public FilterFunction<DistanceFromPoint> filterFunction() {
        return this.distanceComparison;
    }

    @Override
    public int parameterCount() {
        return 2;
    }

    @Override
    public void setValueFromArgs(Map<Integer, Object> params) {
        Point point;
        Distance distance;
        if (this.cypherFilter == null) {
            throw new IllegalStateException("Can't set value from args when cypherFilter is null.");
        }
        Object firstArg = params.get(this.cypherFilter().getPropertyPosition());
        Object secondArg = params.get(this.cypherFilter().getPropertyPosition() + 1);
        if (firstArg instanceof Distance && secondArg instanceof Point) {
            distance = (Distance)firstArg;
            point = (Point)secondArg;
        } else if (secondArg instanceof Distance && firstArg instanceof Point) {
            distance = (Distance)secondArg;
            point = (Point)firstArg;
        } else {
            throw new IllegalArgumentException("findNear requires an argument of type Distance and an argument of type Point");
        }
        double meters = distance.getMetric() == Metrics.KILOMETERS ? distance.getValue() * 1000.0 : (distance.getMetric() == Metrics.MILES ? distance.getValue() / 6.2137E-4 : distance.getValue());
        this.distanceComparison.setValue(new DistanceFromPoint(Double.valueOf(point.getX()), Double.valueOf(point.getY()), Double.valueOf(distance.getValue() * meters)));
    }
}

