/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.transaction;

import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.neo4j.transaction.Neo4jTransactionStatus;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;

public class Neo4jTransactionManager
implements PlatformTransactionManager {
    private final Logger logger = LoggerFactory.getLogger(Neo4jTransactionManager.class);
    private final Session session;

    public Neo4jTransactionManager(Session session) {
        this.session = session;
    }

    public TransactionStatus getTransaction(TransactionDefinition transactionDefinition) throws TransactionException {
        this.logger.debug("Requesting to create or join a transaction");
        return new Neo4jTransactionStatus(this.session, transactionDefinition);
    }

    public void commit(TransactionStatus transactionStatus) throws TransactionException {
        Transaction tx = ((Neo4jTransactionStatus)transactionStatus).getTransaction();
        if (transactionStatus.isNewTransaction() && this.canCommit(tx)) {
            this.logger.debug("Commit requested: " + tx + ", status: " + tx.status().toString());
            tx.commit();
            tx.close();
        }
    }

    public void rollback(TransactionStatus transactionStatus) throws TransactionException {
        Transaction tx = ((Neo4jTransactionStatus)transactionStatus).getTransaction();
        if (transactionStatus.isNewTransaction() && this.canRollback(tx)) {
            this.logger.debug("Rollback requested: " + tx + ", status: " + tx.status().toString());
            tx.rollback();
            tx.close();
        }
    }

    private boolean canCommit(Transaction tx) {
        switch (tx.status()) {
            case COMMIT_PENDING: {
                return true;
            }
            case OPEN: {
                return true;
            }
        }
        return false;
    }

    private boolean canRollback(Transaction tx) {
        switch (tx.status()) {
            case OPEN: {
                return true;
            }
            case ROLLBACK_PENDING: {
                return true;
            }
        }
        return false;
    }
}

