/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.core.TypeRepresentationStrategy;
import org.springframework.data.neo4j.mapping.RelationshipResult;
import org.springframework.data.neo4j.support.mapping.EntityStateHandler;

public class EntityRemover {
    private EntityStateHandler entityStateHandler;
    private TypeRepresentationStrategy<Node> nodeTypeRepresentationStrategy;
    private TypeRepresentationStrategy<Relationship> relationshipTypeRepresentationStrategy;
    private final GraphDatabase graphDatabase;

    public EntityRemover(EntityStateHandler entityStateHandler, TypeRepresentationStrategy<Node> nodeTypeRepresentationStrategy, TypeRepresentationStrategy<Relationship> relationshipTypeRepresentationStrategy, GraphDatabase graphDatabase) {
        this.entityStateHandler = entityStateHandler;
        this.nodeTypeRepresentationStrategy = nodeTypeRepresentationStrategy;
        this.relationshipTypeRepresentationStrategy = relationshipTypeRepresentationStrategy;
        this.graphDatabase = graphDatabase;
    }

    public void removeNodeEntity(Object entity) {
        Node node = this.entityStateHandler.getPersistentState(entity, Node.class);
        if (node == null) {
            return;
        }
        this.removeNode(node);
    }

    private void removeNode(Node node) {
        this.nodeTypeRepresentationStrategy.preEntityRemoval(node);
        for (Relationship relationship : node.getRelationships()) {
            this.removeRelationship(relationship);
        }
        this.graphDatabase.remove(node);
    }

    public void removeRelationshipEntity(Object entity) {
        Relationship relationship = this.entityStateHandler.getPersistentState(entity, Relationship.class);
        if (relationship == null) {
            return;
        }
        this.removeRelationship(relationship);
    }

    private void removeRelationship(Relationship relationship) {
        this.relationshipTypeRepresentationStrategy.preEntityRemoval(relationship);
        this.graphDatabase.remove(relationship);
    }

    public void removeRelationshipBetween(Object start, Object target, String type) {
        RelationshipResult result = this.entityStateHandler.removeRelationshipTo(start, target, type);
        if (result != null && result.type == RelationshipResult.Type.DELETED) {
            this.relationshipTypeRepresentationStrategy.preEntityRemoval(result.relationship);
        }
    }

    public void remove(Object entity) {
        if (entity instanceof Node) {
            this.removeNode((Node)entity);
            return;
        }
        if (entity instanceof Relationship) {
            this.removeRelationship((Relationship)entity);
            return;
        }
        Class<?> type = entity.getClass();
        if (this.entityStateHandler.isNodeEntity(type)) {
            this.removeNodeEntity(entity);
            return;
        }
        if (this.entityStateHandler.isRelationshipEntity(type)) {
            this.removeRelationshipEntity(entity);
            return;
        }
        throw new IllegalArgumentException("@NodeEntity or @RelationshipEntity annotation required on domain class" + type);
    }
}

