/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import java.lang.reflect.InvocationTargetException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.data.neo4j.config.NullTransactionManager;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.jta.UserTransactionAdapter;

public class JtaTransactionManagerFactoryBean
implements FactoryBean<JtaTransactionManager> {
    private final JtaTransactionManager jtaTransactionManager;

    public JtaTransactionManagerFactoryBean(GraphDatabaseService gds) {
        this.jtaTransactionManager = this.create(gds);
    }

    public JtaTransactionManager getObject() {
        return this.jtaTransactionManager;
    }

    public Class<JtaTransactionManager> getObjectType() {
        return JtaTransactionManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private JtaTransactionManager create(GraphDatabaseService gds) {
        block4: {
            if (gds instanceof GraphDatabase) {
                return this.createJtaTransactionManager((GraphDatabase)gds);
            }
            if (gds instanceof GraphDatabaseAPI) {
                try {
                    return this.createJtaTransactionManager(gds);
                }
                catch (RuntimeException e) {
                    if (!(e.getCause() instanceof NoSuchMethodException)) break block4;
                    return this.createJtaTransactionManagerForOnePointSeven(gds);
                }
            }
        }
        return this.createNullJtaTransactionManager();
    }

    private JtaTransactionManager createJtaTransactionManager(GraphDatabase gdb) {
        TransactionManager transactionManager = gdb.getTransactionManager();
        UserTransactionAdapter userTransaction = new UserTransactionAdapter(transactionManager);
        return new JtaTransactionManager((UserTransaction)userTransaction, transactionManager);
    }

    private JtaTransactionManager createNullJtaTransactionManager() {
        NullTransactionManager transactionManager = new NullTransactionManager();
        UserTransactionAdapter userTransaction = new UserTransactionAdapter((TransactionManager)transactionManager);
        return new JtaTransactionManager((UserTransaction)userTransaction, (TransactionManager)transactionManager);
    }

    private JtaTransactionManager createJtaTransactionManagerForOnePointSeven(GraphDatabaseService gds) {
        TransactionManager transactionManager = this.createTransactionManagerForOnePointSeven(gds);
        UserTransaction userTransaction = this.createUserTransactionForOnePointSeven(gds);
        return new JtaTransactionManager(userTransaction, transactionManager);
    }

    private JtaTransactionManager createJtaTransactionManager(GraphDatabaseService gds) {
        TransactionManager transactionManager = this.createTransactionManagerForOnePointEight(gds);
        UserTransaction userTransaction = this.createUserTransactionForOnePointEight(gds);
        return new JtaTransactionManager(userTransaction, transactionManager);
    }

    private TransactionManager createTransactionManagerForOnePointSeven(GraphDatabaseService gds) {
        return (TransactionManager)this.createDynamically(this.classFor("org.neo4j.kernel.impl.transaction.SpringTransactionManager"), GraphDatabaseService.class, gds);
    }

    private UserTransaction createUserTransactionForOnePointSeven(GraphDatabaseService gds) {
        TransactionManager txManager = (TransactionManager)((GraphDatabaseAPI)gds).getDependencyResolver().resolveDependency(TransactionManager.class);
        return (UserTransaction)this.createDynamically(this.classFor("org.neo4j.kernel.impl.transaction.UserTransactionImpl"), TransactionManager.class, txManager);
    }

    private TransactionManager createTransactionManagerForOnePointEight(GraphDatabaseService gds) {
        return (TransactionManager)this.createDynamically(this.classFor("org.neo4j.kernel.impl.transaction.SpringTransactionManager"), GraphDatabaseAPI.class, gds);
    }

    private UserTransaction createUserTransactionForOnePointEight(GraphDatabaseService gds) {
        return (UserTransaction)this.createDynamically(this.classFor("org.neo4j.kernel.impl.transaction.UserTransactionImpl"), GraphDatabaseAPI.class, gds);
    }

    private <T> Class<T> classFor(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Class not found", cnfe);
        }
    }

    private <T> T createDynamically(Class<T> requiredClass, Class<?> argumentClass, Object gds) {
        try {
            return requiredClass.getDeclaredConstructor(argumentClass).newInstance(gds);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error accessing constructor of class " + requiredClass + " for parameter type " + argumentClass, e);
        }
    }
}

