/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.neo4j.mapping.IndexInfo;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;

public class PartInfo {
    private final PersistentPropertyPath<Neo4jPersistentProperty> path;
    private final String identifier;
    private final Part part;
    private final int index;
    private final String paramName;

    public PartInfo(PersistentPropertyPath<Neo4jPersistentProperty> path, String identifier, Part part) {
        this(path, identifier, part, -1, null);
    }

    public PartInfo(PersistentPropertyPath<Neo4jPersistentProperty> path, String identifier, Part part, int index, String paramName) {
        Assert.notNull(path);
        Assert.hasText((String)identifier);
        this.path = path;
        this.identifier = identifier;
        this.part = part;
        this.paramName = paramName;
        this.index = index;
    }

    protected Part.Type getType() {
        return this.part.getType();
    }

    Neo4jPersistentProperty getLeafProperty() {
        return (Neo4jPersistentProperty)this.path.getLeafProperty();
    }

    public boolean isPrimitiveProperty() {
        return !this.isRelationship();
    }

    private boolean isRelationship() {
        return this.getLeafProperty().isRelationship();
    }

    public boolean isLabelIndexed() {
        return this.isIndexed() && this.getLeafProperty().getIndexInfo().isLabelBased();
    }

    public boolean isIndexed() {
        return this.getLeafProperty().isIndexed();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getParameterIndex() {
        return this.index;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getIndexName() {
        return this.getIndexInfo().getIndexName();
    }

    public boolean isFullText() {
        return this.isIndexed() && this.getIndexInfo().isFullText();
    }

    public boolean isSpatial() {
        return this.isIndexed() && this.getIndexInfo().getIndexType() == IndexType.POINT;
    }

    private IndexInfo getIndexInfo() {
        return this.getLeafProperty().getIndexInfo();
    }

    String getNeo4jPropertyName() {
        Neo4jPersistentProperty leafProperty = this.getLeafProperty();
        return leafProperty.getNeo4jPropertyName();
    }

    public String getIndexKey() {
        return this.getIndexInfo().getIndexKey();
    }

    boolean sameIndex(PartInfo startPartInfo) {
        return startPartInfo.getIndexName().equals(this.getIndexName());
    }

    boolean sameIdentifier(PartInfo startPartInfo) {
        return startPartInfo.getIdentifier().equals(this.getIdentifier());
    }
}

