/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.RelationshipEntities;
import org.springframework.data.neo4j.fieldaccess.RelationshipHelper;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipInfo;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class RelatedToViaSingleFieldAccessorFactory
implements FieldAccessorFactory {
    private Neo4jTemplate template;

    public RelatedToViaSingleFieldAccessorFactory(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        if (!property.isRelationship()) {
            return false;
        }
        return property.getRelationshipInfo().isRelatedToVia() && property.getRelationshipInfo().isSingle();
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        RelationshipInfo relationshipInfo = property.getRelationshipInfo();
        return new RelatedToViaSingleFieldAccessor(relationshipInfo.getRelationshipType(), relationshipInfo.getDirection(), relationshipInfo.getTargetType().getType(), this.template, property);
    }

    public static class RelatedToViaSingleFieldAccessor
    implements FieldAccessor {
        private final Class<?> relatedType;
        private final Neo4jTemplate template;
        private final Neo4jPersistentProperty property;
        private final RelationshipHelper relationshipHelper;
        private final RelationshipEntities relationshipEntities;

        public RelatedToViaSingleFieldAccessor(RelationshipType type, Direction direction, Class<?> relatedType, Neo4jTemplate template, Neo4jPersistentProperty property) {
            this.relationshipHelper = new RelationshipHelper(template, direction, type);
            this.relationshipEntities = new RelationshipEntities(this.relationshipHelper, property);
            this.relatedType = relatedType;
            this.template = template;
            this.property = property;
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            Node startNode = this.relationshipHelper.checkAndGetNode(entity);
            Map<Node, Object> endNodeToEntityMapping = this.relationshipEntities.loadEndNodeToRelationshipEntityMapping(startNode, this.toSet(newVal), this.relatedType);
            this.relationshipHelper.removeMissingRelationshipsInStoreAndKeepOnlyNewRelationShipsInSet(startNode, endNodeToEntityMapping.keySet(), null);
            this.persistEntities(endNodeToEntityMapping.values(), this.relationshipHelper.getRelationshipType());
            return newVal;
        }

        private Iterable<Object> toSet(Object newVal) {
            if (newVal == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(newVal);
        }

        private void persistEntities(Collection<Object> relationshipEntities, RelationshipType relationshipType) {
            for (Object entity : relationshipEntities) {
                this.template.save(entity, relationshipType);
            }
        }

        @Override
        public boolean isWriteable(Object entity) {
            return true;
        }

        @Override
        public Object getValue(Object entity, MappingPolicy mappingPolicy) {
            Node node = this.relationshipHelper.checkAndGetNode(entity);
            Relationship rel = this.relationshipHelper.getSingleRelationship(node);
            return DoReturn.doReturn(rel == null ? null : (Object)this.template.createEntityFromState(rel, this.relatedType, mappingPolicy));
        }
    }
}

