/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.PropertyConverter;
import org.springframework.data.neo4j.fieldaccess.PropertyFieldAccessorFactory;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.Neo4jTemplate;

@Configurable
public class ConvertingNodePropertyFieldAccessorFactory
implements FieldAccessorFactory {
    private final Neo4jTemplate template;

    public ConvertingNodePropertyFieldAccessorFactory(Neo4jTemplate template) {
        this.template = template;
    }

    private ConversionService getConversionService() {
        return this.template.getConversionService();
    }

    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        ConversionService conversionService = this.getConversionService();
        return property.isSerializablePropertyField(conversionService);
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        return new ConvertingNodePropertyFieldAccessor(property, this.template);
    }

    public static class ConvertingNodePropertyFieldAccessor
    extends PropertyFieldAccessorFactory.PropertyFieldAccessor {
        private final PropertyConverter propertyConverter;

        public ConvertingNodePropertyFieldAccessor(Neo4jPersistentProperty property, Neo4jTemplate template) {
            super(template, property);
            this.propertyConverter = new PropertyConverter(template.getConversionService(), property);
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            Object value = this.propertyConverter.serializeIfNotBuiltIn(newVal);
            super.setValue(entity, value, mappingPolicy);
            return newVal;
        }

        @Override
        public Object doGetValue(Object entity) {
            return this.propertyConverter.deserializeIfNotBuiltIn(super.doGetValue(entity));
        }

        @Override
        protected Object convertSimplePropertyValue(Object value) {
            return value;
        }
    }
}

