/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.ParameterResolver;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.query.CypherQueryEngine;
import org.springframework.data.neo4j.template.GraphCallback;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class GraphRepositoryQuery
implements RepositoryQuery,
ParameterResolver {
    private final GraphQueryMethod queryMethod;
    protected final Neo4jTemplate template;

    public GraphRepositoryQuery(GraphQueryMethod queryMethod, Neo4jTemplate template) {
        Assert.notNull((Object)((Object)queryMethod));
        Assert.notNull((Object)template);
        this.queryMethod = queryMethod;
        this.template = template;
    }

    protected Neo4jTemplate getTemplate() {
        return this.template;
    }

    @Override
    public Map<Parameter, Object> resolveParameters(Map<Parameter, Object> parameters) {
        LinkedHashMap<Parameter, Object> result = new LinkedHashMap<Parameter, Object>();
        for (Map.Entry<Parameter, Object> entry : parameters.entrySet()) {
            result.put(entry.getKey(), this.convertGraphEntityToId(entry.getValue()));
        }
        return result;
    }

    private Object convertGraphEntityToId(Object value) {
        Node state;
        Class<?> type = value.getClass();
        if (this.template.isNodeEntity(type) && (state = (Node)this.template.getPersistentState(value)) != null) {
            return state.getId();
        }
        if (this.template.isRelationshipEntity(type) && (state = (Relationship)this.template.getPersistentState(value)) != null) {
            return state.getId();
        }
        return value;
    }

    public Object execute(final Object[] parameters) {
        return this.template.exec(new GraphCallback<Object>(){

            @Override
            public Object doWithGraph(GraphDatabase graph) throws Exception {
                ParametersParameterAccessor accessor = new ParametersParameterAccessor(GraphRepositoryQuery.this.queryMethod.getParameters(), parameters);
                Map<String, Object> params = GraphRepositoryQuery.this.resolveParams((ParameterAccessor)accessor);
                String queryString = GraphRepositoryQuery.this.createQueryWithPagingAndSorting((ParameterAccessor)accessor);
                return GraphRepositoryQuery.this.dispatchQuery(queryString, params, (ParameterAccessor)accessor);
            }
        });
    }

    protected Map<String, Object> resolveParams(ParameterAccessor accessor) {
        return this.queryMethod.resolveParams(accessor, this);
    }

    protected String createQueryWithPagingAndSorting(ParameterAccessor accessor) {
        return this.queryMethod.getQueryString();
    }

    protected Object dispatchQuery(String queryString, Map<String, Object> params, ParameterAccessor accessor) {
        GraphQueryMethod queryMethod = this.getQueryMethod();
        CypherQueryEngine queryEngine = this.getQueryEngine();
        Class<?> compoundType = queryMethod.getCompoundType();
        if (queryMethod.isPageQuery() || queryMethod.isSliceQuery()) {
            Result<?> result = queryEngine.query(queryString, params).to(compoundType);
            Long count = this.computeCount(params);
            return this.createPage(result, accessor.getPageable(), count, queryMethod.isPageQuery());
        }
        if (queryMethod.isIterableResult()) {
            Result<?> result = queryEngine.query(queryString, params).to(compoundType);
            if (queryMethod.isSetResult()) {
                return IteratorUtil.addToCollection(result, new LinkedHashSet());
            }
            if (queryMethod.isCollectionResult()) {
                return IteratorUtil.addToCollection(result, new ArrayList());
            }
            return result;
        }
        return queryEngine.query(queryString, params).to(queryMethod.getReturnType()).singleOrNull();
    }

    private Long computeCount(Map<String, Object> params) {
        String countQuery = this.queryMethod.getCountQueryString();
        if (countQuery == null || !StringUtils.hasText((String)countQuery)) {
            return null;
        }
        return this.getQueryEngine().query(countQuery, params).to(Long.class).singleOrNull();
    }

    public GraphQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected Object createPage(Iterable<?> result, Pageable pageable, Long count, boolean isPageQuery) {
        List resultList = (List)IteratorUtil.addToCollection(result, new ArrayList());
        if (pageable == null) {
            return isPageQuery ? new PageImpl(resultList) : new SliceImpl(resultList);
        }
        int pageSize = pageable.getPageSize();
        int requestedCountStart = pageable.getOffset();
        int resultSize = resultList.size();
        int currentTotal = count != null ? count.intValue() : (resultSize == pageSize ? requestedCountStart + pageSize : requestedCountStart + resultSize);
        int resultWindowSize = Math.min(resultSize, pageSize);
        boolean hasNext = resultWindowSize < resultSize;
        List resultListPage = resultList.subList(0, resultWindowSize);
        return isPageQuery ? new PageImpl(resultListPage, pageable, (long)currentTotal) : new SliceImpl(resultListPage, pageable, hasNext);
    }

    protected abstract CypherQueryEngine getQueryEngine();
}

