/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.EnumSet;
import java.util.List;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.ExactIndexBasedStartClause;
import org.springframework.data.neo4j.repository.query.FullTextIndexBasedStartClause;
import org.springframework.data.neo4j.repository.query.GraphIdStartClause;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.repository.query.StartClause;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;

public class StartClauseFactory {
    public static StartClause create(List<PartInfo> partInfos) {
        Assert.notEmpty(partInfos);
        if (partInfos.size() == 1) {
            return StartClauseFactory.create(partInfos.get(0));
        }
        if (StartClauseFactory.areAllIndexedAndHaveSameIdentifiers(partInfos)) {
            return new FullTextIndexBasedStartClause(partInfos);
        }
        throw new IllegalArgumentException("Cannot determine an appropriate Start Clause for multiple partInfos provided");
    }

    private static boolean areAllIndexedAndHaveSameIdentifiers(List<PartInfo> partInfos) {
        PartInfo firstPart = partInfos.get(0);
        for (PartInfo partInfo : partInfos) {
            if (!partInfo.isIndexed()) {
                return false;
            }
            if (partInfo.sameIdentifier(firstPart)) continue;
            return false;
        }
        return true;
    }

    public static StartClause create(PartInfo partInfo) {
        if (partInfo.isIndexed()) {
            return partInfo.isFullText() || StartClauseFactory.isTextualSearchLikePart(partInfo) ? new FullTextIndexBasedStartClause(partInfo) : new ExactIndexBasedStartClause(partInfo);
        }
        Neo4jPersistentProperty leafProperty = partInfo.getLeafProperty();
        if (leafProperty.isRelationship() || leafProperty.isIdProperty()) {
            return new GraphIdStartClause(partInfo);
        }
        throw new IllegalArgumentException("Cannot determine an appropriate Start Clause for partInfo=" + partInfo);
    }

    private static boolean isTextualSearchLikePart(PartInfo partInfo) {
        return EnumSet.of(Part.Type.LIKE, Part.Type.STARTING_WITH, Part.Type.CONTAINING, Part.Type.ENDING_WITH).contains(partInfo.getType());
    }
}

