/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.cypherdsl.grammar.Execute;
import org.neo4j.cypherdsl.grammar.Skip;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.MapUtil;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.conversion.EndResult;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.CypherDslRepository;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.repository.LegacyIndexSearcher;
import org.springframework.data.neo4j.repository.NamedIndexRepository;
import org.springframework.data.neo4j.repository.SpatialRepository;
import org.springframework.data.neo4j.repository.query.CypherQuery;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.query.CypherQueryEngine;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class AbstractGraphRepository<S extends PropertyContainer, T>
implements GraphRepository<T>,
NamedIndexRepository<T>,
SpatialRepository<T>,
CypherDslRepository<T> {
    private final LegacyIndexSearcher<S, T> legacyIndexSearcher;
    public static final ClosableIterable EMPTY_CLOSABLE_ITERABLE = new ClosableIterable(){

        public void close() {
        }

        public Iterator<?> iterator() {
            return Collections.emptyList().iterator();
        }
    };
    protected final Class<T> clazz;
    protected final Neo4jTemplate template;

    @Override
    public EndResult<T> findWithinWellKnownText(String indexName, String wellKnownText) {
        return this.legacyIndexSearcher.geoQuery(indexName, "withinWKTGeometry", wellKnownText);
    }

    @Override
    public EndResult<T> findWithinDistance(String indexName, double lat, double lon, double distanceKm) {
        return this.legacyIndexSearcher.geoQuery(indexName, "withinDistance", MapUtil.map((Object[])new Object[]{"point", new Double[]{lon, lat}, "distanceInKm", distanceKm}));
    }

    @Override
    public EndResult<T> findWithinBoundingBox(String indexName, double lowerLeftLat, double lowerLeftLon, double upperRightLat, double upperRightLon) {
        return this.legacyIndexSearcher.geoQuery(indexName, "bbox", String.format("[%s, %s, %s, %s]", lowerLeftLon, upperRightLon, lowerLeftLat, upperRightLat));
    }

    protected T createEntity(S node) {
        return this.template.createEntityFromState(node, this.clazz, this.template.getMappingPolicy(this.clazz));
    }

    public AbstractGraphRepository(Neo4jTemplate template, Class<T> clazz) {
        this.template = template;
        this.clazz = clazz;
        this.legacyIndexSearcher = new LegacyIndexSearcher(template, clazz);
    }

    @Transactional
    public <U extends T> U save(U entity) {
        return this.template.save(entity);
    }

    @Transactional
    public <U extends T> Iterable<U> save(Iterable<U> entities) {
        for (U entity : entities) {
            this.save(entity);
        }
        return entities;
    }

    public long count() {
        return this.template.count(this.clazz);
    }

    @Override
    public EndResult<T> findAll() {
        return this.template.findAll(this.clazz);
    }

    public T findOne(Long id) {
        try {
            return this.createEntity(this.getById(id));
        }
        catch (DataRetrievalFailureException e) {
            return null;
        }
    }

    @Override
    public T findByPropertyValue(String property, Object value) {
        return this.findByPropertyValue(null, property, value);
    }

    @Override
    @Deprecated
    public T findByPropertyValue(String indexName, String property, Object value) {
        return this.legacyIndexSearcher.findByPropertyValue(indexName, property, value);
    }

    @Override
    @Deprecated
    public EndResult<T> findAllByPropertyValue(String indexName, String property, Object value) {
        return this.legacyIndexSearcher.findAllByPropertyValue(indexName, property, value);
    }

    @Override
    public EndResult<T> findAllByPropertyValue(String property, Object value) {
        return this.findAllByPropertyValue(null, property, value);
    }

    @Override
    @Deprecated
    public EndResult<T> findAllByQuery(String key, Object query) {
        return this.findAllByQuery(null, key, query);
    }

    @Override
    @Deprecated
    public EndResult<T> findAllByQuery(String indexName, String property, Object query) {
        return this.legacyIndexSearcher.findAllByQuery(indexName, property, query);
    }

    @Override
    @Deprecated
    public EndResult<T> findAllByRange(String property, Number from, Number to) {
        return this.findAllByRange(null, property, from, to);
    }

    @Override
    @Deprecated
    public EndResult<T> findAllByRange(String indexName, String property, Number from, Number to) {
        return this.legacyIndexSearcher.findAllByRange(indexName, property, from, to);
    }

    @Override
    public T findBySchemaPropertyValue(String property, Object value) {
        return this.findAllBySchemaPropertyValue(property, value).singleOrNull();
    }

    @Override
    public EndResult<T> findAllBySchemaPropertyValue(String property, Object value) {
        String SCHEMA_PROP_MATCH_CLAUSE = "MATCH (entity:`%s`) where entity.`%s` = {propValue} return entity";
        Neo4jPersistentEntity<?> persistentEntity = this.template.getEntityType(this.clazz).getEntity();
        Neo4jPersistentProperty persistentProperty = (Neo4jPersistentProperty)persistentEntity.getPersistentProperty(property);
        if (persistentProperty.getIndexInfo() == null || !persistentProperty.getIndexInfo().isLabelBased()) {
            throw new IllegalArgumentException(String.format("property %s.%s is not schema indexed", persistentEntity.getName(), property));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("propValue", value);
        String cypherQuery = String.format("MATCH (entity:`%s`) where entity.`%s` = {propValue} return entity", persistentProperty.getIndexInfo().getIndexName(), property);
        return this.template.query(cypherQuery, params).to(this.clazz);
    }

    protected abstract S getById(long var1);

    public boolean exists(Long id) {
        try {
            return this.getById(id) != null;
        }
        catch (DataRetrievalFailureException e) {
            return false;
        }
    }

    @Override
    public Class getStoredJavaType(Object entity) {
        return this.template.getStoredJavaType(entity);
    }

    @Transactional
    public void delete(T entity) {
        this.template.delete(entity);
    }

    @Transactional
    public void delete(Long id) {
        this.delete(this.findOne(id));
    }

    @Transactional
    public void delete(Iterable<? extends T> entities) {
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    @Transactional
    public void deleteAll() {
        this.delete(this.findAll());
    }

    @Override
    public EndResult<T> findAll(Sort sort) {
        CypherQuery cq = new CypherQuery(this.template.getEntityType(this.clazz).getEntity(), this.template, this.template.isLabelBased());
        return this.query(cq.toQueryString(sort), (Map<String, Object>)Collections.EMPTY_MAP);
    }

    @Override
    public EndResult<T> query(String query, Map<String, Object> params) {
        return this.template.query(query, params).to(this.clazz);
    }

    public Page<T> findAll(Pageable pageable) {
        int count = pageable.getPageSize();
        int offset = pageable.getOffset();
        Iterable foundEntities = this.findAll(pageable.getSort());
        Iterator iterator = foundEntities.iterator();
        PageImpl page = this.extractPage(pageable, count, offset, iterator);
        foundEntities.finish();
        return page;
    }

    public Iterable<T> findAll(final Iterable<Long> ids) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator idIterator = ids.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return idIterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return AbstractGraphRepository.this.template.findOne((Long)idIterator.next(), AbstractGraphRepository.this.clazz);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private PageImpl<T> extractPage(Pageable pageable, int count, int offset, Iterator<T> iterator) {
        ArrayList result = new ArrayList(count);
        int total = this.subList(offset, count, iterator, result);
        if (iterator.hasNext()) {
            ++total;
        }
        return new PageImpl(result, pageable, (long)total);
    }

    private int subList(int skip, int limit, Iterator<T> source, List<T> list) {
        int count = 0;
        while (source.hasNext()) {
            ++count;
            T t = source.next();
            if (skip > 0) {
                --skip;
            } else {
                list.add(t);
                --limit;
            }
            if (limit + skip != 0) continue;
            break;
        }
        return count;
    }

    @Override
    public Page<T> query(Execute query, Execute countQuery, Map<String, Object> params, Pageable page) {
        Execute limitedQuery = ((Skip)query).skip(page.getOffset()).limit(page.getPageSize());
        CypherQueryEngine engine = this.template.queryEngineFor();
        Page result = engine.query(limitedQuery.toString(), params).to(this.clazz).as(Page.class);
        if (countQuery == null) {
            return result;
        }
        Long count = engine.query(countQuery.toString(), params).to(Long.class).singleOrNull();
        if (count == null) {
            return result;
        }
        return new PageImpl(result.getContent(), page, count.longValue());
    }

    @Override
    public Page<T> query(Execute query, Map<String, Object> params, Pageable page) {
        return this.query(query, null, params, page);
    }

    @Override
    public EndResult<T> query(Execute query, Map<String, Object> params) {
        return this.template.queryEngineFor().query(query.toString(), params).to(this.clazz);
    }

    static interface Query<S extends PropertyContainer> {
        public IndexHits<S> query(ReadableIndex<S> var1);
    }
}

