/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.CypherQueryDefinition;
import org.springframework.data.neo4j.repository.query.GraphIdStartClause;
import org.springframework.data.neo4j.repository.query.IdPropertyWhereClause;
import org.springframework.data.neo4j.repository.query.IndexBasedTypeRestrictingWhereClause;
import org.springframework.data.neo4j.repository.query.LabelBasedTypeRestrictingWhereClause;
import org.springframework.data.neo4j.repository.query.MatchClause;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.repository.query.StartClause;
import org.springframework.data.neo4j.repository.query.StartClauseFactory;
import org.springframework.data.neo4j.repository.query.VariableContext;
import org.springframework.data.neo4j.repository.query.WhereClause;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.StringUtils;

public class CypherQuery
implements CypherQueryDefinition {
    private final VariableContext variableContext = new VariableContext();
    private final List<MatchClause> matchClauses = new ArrayList<MatchClause>();
    private final List<StartClause> startClauses = new ArrayList<StartClause>();
    private final List<WhereClause> whereClauses = new ArrayList<WhereClause>();
    private Sort defaultSorts;
    private int index = 0;
    private final Neo4jPersistentEntity<?> entity;
    private final Neo4jTemplate template;
    private boolean isCountQuery = false;
    private boolean useLabels = false;

    public CypherQuery(Neo4jPersistentEntity<?> entity, Neo4jTemplate template, boolean useLabels) {
        this.entity = entity;
        this.template = template;
        this.useLabels = useLabels;
    }

    private String getEntityName(Neo4jPersistentEntity<?> entity) {
        return this.variableContext.getVariableFor(entity);
    }

    private String defaultIndexBasedStartClause(Neo4jPersistentEntity<?> entity) {
        return String.format("`%s`=node:__types__(className=\"%s\")", this.getEntityName(entity), entity.getEntityType().getAlias());
    }

    private String defaultMatchBasedStartClause(Neo4jPersistentEntity<?> entity) {
        return String.format("(`%s`%s)", this.getEntityName(entity), this.toLabelString(entity.getAllLabels()));
    }

    private String toLabelString(Collection<String> labels) {
        if (labels == null || labels.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String label : labels) {
            sb.append(":`").append(label).append("`");
        }
        return sb.toString();
    }

    public void addPart(Part part, PersistentPropertyPath<Neo4jPersistentProperty> path) {
        String variable = this.variableContext.getVariableFor(path);
        PartInfo partInfo = new PartInfo(path, variable, part, this.index);
        MatchClause matchClause = new MatchClause(path);
        Neo4jPersistentProperty leafProperty = partInfo.getLeafProperty();
        boolean isIdProperty = leafProperty.isIdProperty();
        boolean addedMatchClause = false;
        if (partInfo.isPrimitiveProperty() && !isIdProperty) {
            if (!this.addedStartClause(partInfo)) {
                this.whereClauses.add(new WhereClause(partInfo, this.template));
            }
        } else if (leafProperty.isRelationship() || isIdProperty) {
            if (this.useLabels) {
                this.whereClauses.add(new IdPropertyWhereClause(new PartInfo(path, variable, part, this.index), this.template));
                this.whereClauses.add(new LabelBasedTypeRestrictingWhereClause(new PartInfo(path, this.variableContext.getVariableFor(this.entity), part, -1), this.entity, this.template));
                this.matchClauses.add(matchClause);
                addedMatchClause = true;
            } else {
                this.startClauses.add(new GraphIdStartClause(partInfo));
                this.whereClauses.add(new IndexBasedTypeRestrictingWhereClause(new PartInfo(path, this.variableContext.getVariableFor(this.entity), part, -1), this.entity, this.template));
            }
        } else {
            throw new IllegalStateException("Error " + part + " points neither to a primitive nor a entity property of " + this.entity);
        }
        ++this.index;
        if (!addedMatchClause && matchClause.hasRelationship()) {
            this.matchClauses.add(matchClause);
        }
    }

    public CypherQueryDefinition withSort(Sort sorts) {
        this.defaultSorts = sorts;
        return this;
    }

    private Sort getCypherEntityRefAwareSort(Sort sorts) {
        ArrayList<Sort.Order> entityAwareOrders = new ArrayList<Sort.Order>();
        for (Sort.Order o : sorts) {
            entityAwareOrders.add(this.getEntityAwareOrderRef(o));
        }
        return new Sort(entityAwareOrders);
    }

    private Sort.Order getEntityAwareOrderRef(Sort.Order o) {
        return o.getProperty().contains(".") ? o : new Sort.Order(o.getDirection(), this.getEntityName(this.entity) + "." + o.getProperty());
    }

    private boolean addedStartClause(PartInfo partInfo) {
        boolean invalidStartClauseScenario2;
        boolean invalidStartClauseScenario1 = !partInfo.isIndexed();
        boolean bl = invalidStartClauseScenario2 = partInfo.isIndexed() && partInfo.isLabelIndexed();
        if (invalidStartClauseScenario1 || invalidStartClauseScenario2) {
            return false;
        }
        ListIterator<StartClause> it = this.startClauses.listIterator();
        while (it.hasNext()) {
            StartClause startClause = it.next();
            if (!startClause.sameIdentifier(partInfo)) continue;
            if (startClause.sameIndex(partInfo)) {
                startClause.merge(partInfo);
                if (startClause.hasMultipleParts()) {
                    ArrayList<PartInfo> newList = new ArrayList<PartInfo>();
                    newList.addAll(startClause.getPartInfos());
                    it.set(StartClauseFactory.create(newList));
                }
                return true;
            }
            return false;
        }
        this.startClauses.add(StartClauseFactory.create(partInfo));
        return true;
    }

    public PartInfo getPartInfo(int parameterIndex) {
        for (StartClause startClause : this.startClauses) {
            if (startClause.getPartInfo().getParameterIndex() != parameterIndex) continue;
            return startClause.getPartInfo();
        }
        for (WhereClause whereClause : this.whereClauses) {
            if (whereClause.getPartInfo().getParameterIndex() != parameterIndex) continue;
            return whereClause.getPartInfo();
        }
        throw new IllegalArgumentException("Index " + parameterIndex + " not valid");
    }

    @Override
    public Map<Parameter, Object> resolveParameters(Map<Parameter, Object> parameters) {
        for (StartClause startClause : this.startClauses) {
            parameters = startClause.resolveParameters(parameters, this.template);
        }
        for (MatchClause matchClause : this.matchClauses) {
            parameters = matchClause.resolveParameters(parameters);
        }
        for (WhereClause whereClause : this.whereClauses) {
            parameters = whereClause.resolveParameters(parameters);
        }
        return parameters;
    }

    @Override
    public String toQueryString() {
        return this.toQueryString(this.defaultSorts);
    }

    private String render() {
        String startClauses = StringUtils.collectionToDelimitedString(this.startClauses, (String)", ");
        String matchClauses = this.toQueryString(this.matchClauses);
        String whereClauses = StringUtils.collectionToDelimitedString(this.whereClauses, (String)" AND ");
        StringBuilder builder = new StringBuilder("");
        boolean startClauseInUse = this.renderStartClauses(builder, startClauses);
        this.renderMatchClauses(builder, matchClauses, startClauseInUse);
        this.renderWhereClauses(builder, whereClauses);
        this.renderReturnClauses(builder);
        return builder.toString();
    }

    private void renderReturnClauses(StringBuilder builder) {
        String returnEntity = String.format("`%s`", this.getEntityName(this.entity));
        if (this.isCountQuery) {
            builder.append(" RETURN ").append("count(").append(returnEntity).append(")");
        } else {
            builder.append(" RETURN ").append(returnEntity);
        }
    }

    private void renderWhereClauses(StringBuilder builder, String whereClauses) {
        if (StringUtils.hasText((String)whereClauses)) {
            builder.append(" WHERE ").append(whereClauses);
        }
    }

    private void renderMatchClauses(StringBuilder builder, String matchClauses, boolean startClauseInUse) {
        if (StringUtils.hasText((String)matchClauses)) {
            builder.append(" MATCH ").append(matchClauses);
            return;
        }
        if (this.useLabelBasedTRS() && !startClauseInUse) {
            builder.append(" MATCH ").append(this.defaultMatchBasedStartClause(this.entity));
            return;
        }
    }

    private boolean renderStartClauses(StringBuilder builder, String startClauses) {
        if (StringUtils.hasText((String)startClauses)) {
            builder.append("START ").append(startClauses);
            return true;
        }
        if (this.useIndexBasedTRS()) {
            builder.append("START ").append(this.defaultIndexBasedStartClause(this.entity));
            return true;
        }
        return false;
    }

    private boolean useIndexBasedTRS() {
        return !this.useLabels;
    }

    private boolean useLabelBasedTRS() {
        return this.useLabels;
    }

    private String addSorts(Sort sort) {
        List<String> sorts = this.formatSorts(sort);
        return !sorts.isEmpty() ? String.format(" ORDER BY %s", StringUtils.collectionToCommaDelimitedString(sorts)) : "";
    }

    private List<String> formatSorts(Sort sort) {
        ArrayList<String> result = new ArrayList<String>();
        if (sort == null) {
            return result;
        }
        for (Sort.Order order : sort) {
            result.add(String.format("%s %s", order.getProperty(), order.getDirection()));
        }
        return result;
    }

    private String toQueryString(List<MatchClause> matchClauses) {
        ArrayList<String> result = new ArrayList<String>(matchClauses.size());
        for (MatchClause matchClause : matchClauses) {
            result.add(matchClause.toString(this.variableContext));
        }
        return StringUtils.collectionToDelimitedString(result, (String)", ");
    }

    @Override
    public String toQueryString(Sort sort) {
        return this.toQueryString(sort, true);
    }

    private String toQueryString(Sort sort, boolean applyMissingRefs) {
        StringBuilder builder = new StringBuilder(this.render());
        if (sort != null) {
            builder.append(this.addSorts(applyMissingRefs ? this.getCypherEntityRefAwareSort(sort) : sort));
        }
        return builder.toString().trim();
    }

    @Override
    public String toQueryString(Pageable pageable) {
        if (pageable == null) {
            return this.render();
        }
        StringBuilder builder = new StringBuilder(this.toQueryString(pageable.getSort()));
        builder.append(String.format(" SKIP %d LIMIT %d", pageable.getOffset(), pageable.getPageSize()));
        return builder.toString().trim();
    }

    public String toString() {
        return this.toQueryString();
    }

    public void setIsCountQuery(boolean isCountQuery) {
        this.isCountQuery = isCountQuery;
    }
}

