/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.repository.GraphEntityInformation;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.repository.core.support.AbstractEntityInformation;

public class GraphMetamodelEntityInformation<S extends PropertyContainer, T>
extends AbstractEntityInformation<T, Long>
implements GraphEntityInformation<S, T> {
    private Neo4jTemplate template;
    private final RelationshipEntity relationshipEntity;
    private final NodeEntity nodeEntity;

    public GraphMetamodelEntityInformation(Class domainClass, Neo4jTemplate template) {
        super(domainClass);
        this.template = template;
        this.nodeEntity = this.getJavaType().getAnnotation(NodeEntity.class);
        this.relationshipEntity = this.getJavaType().getAnnotation(RelationshipEntity.class);
    }

    @Override
    public boolean isNodeEntity() {
        return this.nodeEntity != null;
    }

    @Override
    public boolean isPartialEntity() {
        return this.nodeEntity != null && this.nodeEntity.partial();
    }

    @Override
    public boolean isRelationshipEntity() {
        return this.relationshipEntity != null;
    }

    public boolean isNew(T entity) {
        return this.template.getPersistentState(entity) != null;
    }

    public Long getId(T entity) {
        Object state = this.template.getPersistentState(entity);
        if (this.isNodeEntity()) {
            return ((Node)state).getId();
        }
        return ((Relationship)state).getId();
    }

    public Class<Long> getIdType() {
        return Long.class;
    }
}

