/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Constructor;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.annotation.GraphTraversal;
import org.springframework.data.neo4j.core.FieldTraversalDescriptionBuilder;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class TraversalFieldAccessorFactory
implements FieldAccessorFactory {
    private final Neo4jTemplate template;

    public TraversalFieldAccessorFactory(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty f) {
        GraphTraversal graphEntityTraversal = f.getAnnotation(GraphTraversal.class);
        return graphEntityTraversal != null && graphEntityTraversal.traversal() != FieldTraversalDescriptionBuilder.class && f.getType().equals(Iterable.class);
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        return new TraversalFieldAccessor(property, this.template);
    }

    public static class TraversalFieldAccessor
    implements FieldAccessor {
        protected final Neo4jPersistentProperty property;
        private final Neo4jTemplate template;
        private final FieldTraversalDescriptionBuilder fieldTraversalDescriptionBuilder;
        private Class<?> target;
        protected String[] params;

        public TraversalFieldAccessor(Neo4jPersistentProperty property, Neo4jTemplate template) {
            this.property = property;
            this.template = template;
            GraphTraversal graphEntityTraversal = property.getAnnotation(GraphTraversal.class);
            this.target = this.resolveTarget(graphEntityTraversal, property);
            this.params = graphEntityTraversal.params();
            this.fieldTraversalDescriptionBuilder = this.createTraversalDescription(graphEntityTraversal);
        }

        private Class<?> resolveTarget(GraphTraversal graphTraversal, Neo4jPersistentProperty property) {
            if (!graphTraversal.elementClass().equals(Object.class)) {
                return graphTraversal.elementClass();
            }
            Class result = property.getTypeInformation().getActualType().getType();
            Class[] allowedTypes = new Class[]{Node.class, Relationship.class, Path.class};
            if (this.checkTypes(result, allowedTypes)) {
                return result;
            }
            if (this.template.isNodeEntity(result)) {
                return result;
            }
            if (this.template.isRelationshipEntity(result)) {
                return result;
            }
            throw new IllegalArgumentException("The target result type " + result + " of the traversal is no subclass of the allowed types: " + property + " " + allowedTypes);
        }

        private boolean checkTypes(Class<?> target, Class<?> ... allowedTypes) {
            for (Class<?> type : allowedTypes) {
                if (!type.isAssignableFrom(target)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isWriteable(Object entity) {
            return false;
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            throw new InvalidDataAccessApiUsageException("Cannot set readonly traversal description field " + this.property);
        }

        @Override
        public Object getValue(Object entity, MappingPolicy mappingPolicy) {
            TraversalDescription traversalDescription = this.fieldTraversalDescriptionBuilder.build(entity, this.property, this.params);
            return DoReturn.doReturn(this.template.traverse(entity, this.target, traversalDescription));
        }

        private FieldTraversalDescriptionBuilder createTraversalDescription(GraphTraversal graphEntityTraversal) {
            try {
                Class<? extends FieldTraversalDescriptionBuilder> traversalDescriptionClass = graphEntityTraversal.traversal();
                Constructor<? extends FieldTraversalDescriptionBuilder> constructor = traversalDescriptionClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating TraversalDescription from " + this.property, e);
            }
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }
    }
}

