/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.index;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.springframework.data.neo4j.annotation.Indexed;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.ParameterCheck;
import org.springframework.data.neo4j.support.index.IndexProvider;
import org.springframework.data.neo4j.support.index.IndexType;

public class IndexProviderImpl
implements IndexProvider {
    private final GraphDatabase graphDatabase;

    public IndexProviderImpl(GraphDatabase graphDatabase) {
        this.graphDatabase = graphDatabase;
    }

    @Override
    public <S extends PropertyContainer, T> Index<S> getIndex(Neo4jPersistentEntity<T> type) {
        return this.getIndex(type, null);
    }

    @Override
    public <S extends PropertyContainer, T> Index<S> getIndex(Neo4jPersistentEntity<T> type, String indexName) {
        return this.getIndex(type, indexName, null);
    }

    @Override
    public <S extends PropertyContainer, T> Index<S> getIndex(Neo4jPersistentEntity<T> persistentEntity, String indexName, IndexType indexType) {
        if (persistentEntity == null) {
            ParameterCheck.notNull((Object)indexName, "indexName");
            return this.getIndex(indexName);
        }
        Class type = persistentEntity.getType();
        if (indexName == null) {
            indexName = this.customizeIndexName(Indexed.Name.get(type), type);
        }
        boolean useExistingIndex = indexType == null;
        boolean isNodeEntity = persistentEntity.isNodeEntity();
        boolean isRelationshipEntity = persistentEntity.isRelationshipEntity();
        if (useExistingIndex) {
            if (isNodeEntity || isRelationshipEntity) {
                return this.graphDatabase.getIndex(indexName);
            }
            throw new IllegalArgumentException("Wrong index type supplied: " + type + " expected Node- or Relationship-Entity");
        }
        if (isNodeEntity) {
            return this.createIndex(Node.class, indexName, indexType);
        }
        if (isRelationshipEntity) {
            return this.createIndex(Relationship.class, indexName, indexType);
        }
        throw new IllegalArgumentException("Wrong index type supplied: " + type + " expected Node- or Relationship-Entity");
    }

    @Override
    public <T extends PropertyContainer> Index<T> getIndex(String indexName) {
        return this.graphDatabase.getIndex(indexName);
    }

    @Override
    public boolean isNode(Class<? extends PropertyContainer> type) {
        if (type.equals(Node.class)) {
            return true;
        }
        if (type.equals(Relationship.class)) {
            return false;
        }
        throw new IllegalArgumentException("Unknown Graph Primitive, neither Node nor Relationship" + type);
    }

    @Override
    public <T extends PropertyContainer> Index<T> createIndex(Class<T> propertyContainerType, String indexName, IndexType fullText) {
        return this.graphDatabase.createIndex(propertyContainerType, indexName, fullText);
    }

    @Override
    public <S extends PropertyContainer> Index<S> getIndex(Neo4jPersistentProperty property, Class<?> instanceType) {
        Indexed indexedAnnotation = property.getAnnotation(Indexed.class);
        Neo4jPersistentEntity<?> declaringType = property.getOwner();
        String providedIndexName = this.providedIndexName(indexedAnnotation);
        Indexed.Level level = this.indexingLevel(indexedAnnotation);
        String indexName = this.customizeIndexName(Indexed.Name.get(level, declaringType.getType(), providedIndexName, instanceType), instanceType);
        if (!property.isIndexed() || property.getIndexInfo().getIndexType() == IndexType.SIMPLE) {
            return this.getIndex(declaringType, indexName, IndexType.SIMPLE);
        }
        String defaultIndexName = this.customizeIndexName(Indexed.Name.get(level, declaringType.getType(), null, instanceType.getClass()), instanceType);
        if (providedIndexName == null || providedIndexName.equals(defaultIndexName)) {
            throw new IllegalStateException("Index name for " + property + " must differ from the default name: " + defaultIndexName);
        }
        return this.getIndex(declaringType, indexName, property.getIndexInfo().getIndexType());
    }

    private Indexed.Level indexingLevel(Indexed indexedAnnotation) {
        return indexedAnnotation == null ? Indexed.Level.CLASS : indexedAnnotation.level();
    }

    private String providedIndexName(Indexed indexedAnnotation) {
        return indexedAnnotation == null || indexedAnnotation.indexName().isEmpty() ? null : indexedAnnotation.indexName();
    }

    @Override
    public String createIndexValueForType(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Value to be indexed must not be null " + value);
        }
        return value.toString();
    }

    @Override
    public String customizeIndexName(String indexName, Class<?> type) {
        return indexName;
    }
}

