/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.CypherQuery;
import org.springframework.data.neo4j.repository.query.CypherQueryDefinition;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.repository.query.parser.Part;

class CypherQueryBuilder {
    private final MappingContext<? extends Neo4jPersistentEntity<?>, Neo4jPersistentProperty> context;
    private final CypherQuery query;

    public CypherQueryBuilder(MappingContext<? extends Neo4jPersistentEntity<?>, Neo4jPersistentProperty> context, Class<?> type, Neo4jTemplate template) {
        this.context = context;
        Neo4jPersistentEntity entity = (Neo4jPersistentEntity)context.getPersistentEntity(type);
        this.query = new CypherQuery(entity, template);
    }

    public CypherQueryBuilder asCountQuery() {
        this.query.setIsCountQuery(true);
        return this;
    }

    public CypherQueryBuilder addRestriction(Part part) {
        this.query.addPart(part, (PersistentPropertyPath<Neo4jPersistentProperty>)this.context.getPersistentPropertyPath(part.getProperty()));
        return this;
    }

    public CypherQueryDefinition buildQuery(Sort sort) {
        return this.query.withSort(sort);
    }

    public CypherQueryDefinition buildQuery() {
        return this.query;
    }

    public String toString() {
        return this.query.toQueryString();
    }
}

