/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import org.neo4j.graphdb.PropertyContainer;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.neo4j.core.TypeRepresentationStrategy;
import org.springframework.data.neo4j.support.mapping.StoredEntityType;

public class TRSTypeAliasAccessor<S extends PropertyContainer>
implements TypeAliasAccessor<S> {
    private final TypeRepresentationStrategy<S> typeRepresentationStrategy;

    public TRSTypeAliasAccessor(TypeRepresentationStrategy<S> typeRepresentationStrategy) {
        this.typeRepresentationStrategy = typeRepresentationStrategy;
    }

    public Object readAliasFrom(S source) {
        try {
            return this.typeRepresentationStrategy.readAliasFrom(source);
        }
        catch (UnsupportedOperationException uoe) {
            return null;
        }
    }

    public void writeTypeTo(S sink, Object type) {
        if (type == null) {
            return;
        }
        if (!(type instanceof StoredEntityType)) {
            throw new IllegalArgumentException("TypeRepresentationStrategies can only store StoredEntityType instances, not " + type.getClass());
        }
        this.typeRepresentationStrategy.writeTypeTo(sink, (StoredEntityType)type);
    }
}

