/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.typerepresentation;

import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.ClosableIterable;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.core.TypeRepresentationStrategy;
import org.springframework.data.neo4j.support.index.ClosableIndexHits;
import org.springframework.data.neo4j.support.index.IndexProvider;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.support.mapping.StoredEntityType;

public abstract class AbstractIndexingTypeRepresentationStrategy<S extends PropertyContainer>
implements TypeRepresentationStrategy<S> {
    public static final String TYPE_PROPERTY_NAME = "__type__";
    public static final String INDEX_KEY = "className";
    protected String INDEX_NAME;
    protected final GraphDatabase graphDb;
    protected final IndexProvider indexProvider;
    private final Class<? extends PropertyContainer> clazz;
    private Index<S> typesIndex;

    public AbstractIndexingTypeRepresentationStrategy(GraphDatabase graphDb, IndexProvider indexProvider, String indexName, Class<? extends PropertyContainer> clazz) {
        this.graphDb = graphDb;
        this.indexProvider = indexProvider;
        this.INDEX_NAME = indexName;
        this.clazz = clazz;
        this.typesIndex = this.createTypesIndex();
    }

    private Index<S> createTypesIndex() {
        return this.graphDb.createIndex(this.clazz, this.INDEX_NAME, IndexType.SIMPLE);
    }

    @Override
    public void writeTypeTo(S state, StoredEntityType type) {
        this.addToTypesIndex(state, type);
        state.setProperty(TYPE_PROPERTY_NAME, type.getAlias());
    }

    @Override
    public long count(StoredEntityType type) {
        long count = 0L;
        Object value = type.getAlias();
        IndexHits<S> hits = this.get(value);
        while (hits.hasNext()) {
            hits.next();
            ++count;
        }
        return count;
    }

    private IndexHits<S> get(Object value) {
        try {
            return this.typesIndex.get(INDEX_KEY, value);
        }
        catch (IllegalStateException ise) {
            this.typesIndex = this.createTypesIndex();
            return this.typesIndex.get(INDEX_KEY, value);
        }
    }

    @Override
    public void preEntityRemoval(S state) {
        this.remove(state);
    }

    private void remove(S state) {
        try {
            this.typesIndex.remove(state);
        }
        catch (IllegalStateException ise) {
            this.typesIndex = this.createTypesIndex();
            this.typesIndex.remove(state);
        }
    }

    @Override
    public <U> ClosableIterable<S> findAll(StoredEntityType type) {
        return this.findAllRelBacked(type);
    }

    @Override
    public Object readAliasFrom(S propertyContainer) {
        if (propertyContainer == null) {
            throw new IllegalArgumentException("Relationship or Node is null");
        }
        return propertyContainer.getProperty(TYPE_PROPERTY_NAME);
    }

    protected void addToTypesIndex(S element, StoredEntityType type) {
        if (type == null) {
            return;
        }
        Object value = type.getAlias();
        if (this.indexProvider != null) {
            value = this.indexProvider.createIndexValueForType(type.getAlias());
        }
        this.add(element, value);
        for (StoredEntityType superType : type.getSuperTypes()) {
            this.addToTypesIndex(element, superType);
        }
    }

    private void add(S element, Object value) {
        try {
            this.typesIndex.add(element, INDEX_KEY, value);
        }
        catch (IllegalStateException ise) {
            this.typesIndex = this.createTypesIndex();
            this.typesIndex.add(element, INDEX_KEY, value);
        }
    }

    private ClosableIterable<S> findAllRelBacked(StoredEntityType type) {
        Object value = type.getAlias();
        if (this.indexProvider != null) {
            value = this.indexProvider.createIndexValueForType(type.getAlias());
        }
        IndexHits<S> allEntitiesOfType = this.get(value);
        return new ClosableIndexHits<S>(allEntitiesOfType);
    }
}

