/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import java.lang.annotation.Annotation;
import java.util.IdentityHashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.neo4j.annotation.EndNode;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.annotation.RelationshipType;
import org.springframework.data.neo4j.annotation.StartNode;
import org.springframework.data.neo4j.mapping.ManagedEntity;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipProperties;
import org.springframework.data.neo4j.support.mapping.StoredEntityType;
import org.springframework.data.util.TypeInformation;

public class Neo4jPersistentEntityImpl<T>
extends BasicPersistentEntity<T, Neo4jPersistentProperty>
implements Neo4jPersistentEntity<T>,
RelationshipProperties {
    private Map<Class<? extends Annotation>, Annotation> annotations = new IdentityHashMap<Class<? extends Annotation>, Annotation>();
    private final boolean managed;
    private Neo4jPersistentProperty startNodeProperty;
    private Neo4jPersistentProperty endNodeProperty;
    private Neo4jPersistentProperty relationshipType;
    private StoredEntityType storedType;
    private Neo4jPersistentProperty uniqueProperty;
    private final boolean shouldUseShortNames;

    public Neo4jPersistentEntityImpl(TypeInformation<T> information) {
        super(information);
        for (Annotation annotation : information.getType().getAnnotations()) {
            this.annotations.put(annotation.annotationType(), annotation);
        }
        this.managed = ManagedEntity.class.isAssignableFrom(information.getType());
        this.shouldUseShortNames = this.shouldUseShortNames();
    }

    void updateStoredType(StoredEntityType storedType) {
        this.storedType = storedType;
    }

    public void verify() {
        super.verify();
        if (this.isManaged() || this.getType().isInterface()) {
            return;
        }
        Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)this.getIdProperty();
        if (idProperty == null) {
            throw new MappingException("No id property in " + this);
        }
        if (idProperty.getType().isPrimitive()) {
            throw new MappingException("The type of the id-property in " + idProperty + " must not be a primitive type but an object type like java.lang.Long");
        }
    }

    @Override
    public boolean useShortNames() {
        return this.shouldUseShortNames;
    }

    private boolean shouldUseShortNames() {
        NodeEntity graphEntity = this.getAnnotation(NodeEntity.class);
        if (graphEntity != null) {
            return graphEntity.useShortNames();
        }
        RelationshipEntity graphRelationship = this.getAnnotation(RelationshipEntity.class);
        if (graphRelationship != null) {
            return graphRelationship.useShortNames();
        }
        return false;
    }

    @Override
    public boolean isNodeEntity() {
        return this.hasAnnotation(NodeEntity.class);
    }

    @Override
    public boolean isRelationshipEntity() {
        return this.hasAnnotation(RelationshipEntity.class);
    }

    private <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return (T)this.annotations.get(annotationType);
    }

    private <T extends Annotation> boolean hasAnnotation(Class<T> annotationType) {
        return this.annotations.containsKey(annotationType);
    }

    @Override
    public void setPersistentState(Object entity, PropertyContainer state) {
        Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)this.getIdProperty();
        Object id = this.getStateId(state);
        idProperty.setValue(entity, id);
    }

    private Object getStateId(PropertyContainer state) {
        if (state == null) {
            return null;
        }
        if (this.isNodeEntity()) {
            return ((Node)state).getId();
        }
        if (this.isRelationshipEntity()) {
            return ((Relationship)state).getId();
        }
        throw new MappingException("Entity has to be annotated with @NodeEntity or @RelationshipEntity" + this);
    }

    @Override
    public Object getPersistentId(Object entity) {
        Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)this.getIdProperty();
        if (idProperty == null) {
            throw new MappingException("No field annotated with @GraphId found in " + this.getEntityName());
        }
        return idProperty.getValue(entity, idProperty.getMappingPolicy());
    }

    @Override
    public RelationshipProperties getRelationshipProperties() {
        return this.isRelationshipEntity() ? this : null;
    }

    public String getEntityName() {
        return this.getType().getName();
    }

    public boolean isManaged() {
        return this.managed;
    }

    @Override
    public boolean isUnique() {
        return this.uniqueProperty != null;
    }

    public void addPersistentProperty(Neo4jPersistentProperty property) {
        super.addPersistentProperty((PersistentProperty)property);
        if (property.isAnnotationPresent(RelationshipType.class)) {
            this.relationshipType = property;
        }
        if (property.isUnique()) {
            if (this.uniqueProperty != null) {
                throw new MappingException("A unique property " + this.uniqueProperty.getName() + " has already been defined. Only one unique property is allowed per type");
            }
            this.uniqueProperty = property;
        }
    }

    public void addAssociation(Association<Neo4jPersistentProperty> neo4jPersistentPropertyAssociation) {
        super.addAssociation(neo4jPersistentPropertyAssociation);
        Neo4jPersistentProperty property = (Neo4jPersistentProperty)neo4jPersistentPropertyAssociation.getInverse();
        if (property.isAnnotationPresent(StartNode.class)) {
            this.startNodeProperty = property;
        }
        if (property.isAnnotationPresent(EndNode.class)) {
            this.endNodeProperty = property;
        }
    }

    @Override
    public Neo4jPersistentProperty getStartNodeProperty() {
        return this.startNodeProperty;
    }

    @Override
    public Neo4jPersistentProperty getEndNodeProperty() {
        return this.endNodeProperty;
    }

    @Override
    public Neo4jPersistentProperty getTypeProperty() {
        return this.relationshipType;
    }

    @Override
    public String getRelationshipType() {
        if (!this.isRelationshipEntity()) {
            return null;
        }
        RelationshipEntity annotation = this.getAnnotation(RelationshipEntity.class);
        return annotation.type().isEmpty() ? null : annotation.type();
    }

    public String toString() {
        return String.format("%s %smanaged @%sEntity Annotations: %s", this.getType(), this.isManaged() ? "" : "un", this.isNodeEntity() ? "Node" : "Relationship", this.annotations.keySet());
    }

    @Override
    public MappingPolicy getMappingPolicy() {
        return MappingPolicy.LOAD_POLICY;
    }

    @Override
    public StoredEntityType getEntityType() {
        return this.storedType;
    }

    public boolean matchesAlias(Object alias) {
        return this.storedType.matchesAlias(alias);
    }

    @Override
    public Neo4jPersistentProperty getUniqueProperty() {
        return this.uniqueProperty;
    }
}

