/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.CypherQueryDefinition;
import org.springframework.data.neo4j.repository.query.MatchClause;
import org.springframework.data.neo4j.repository.query.NodeEntityMatchingStartClause;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.repository.query.StartClause;
import org.springframework.data.neo4j.repository.query.TypeRestrictingWhereClause;
import org.springframework.data.neo4j.repository.query.VariableContext;
import org.springframework.data.neo4j.repository.query.WhereClause;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.StringUtils;

public class CypherQuery
implements CypherQueryDefinition {
    private final VariableContext variableContext = new VariableContext();
    private final List<MatchClause> matchClauses = new ArrayList<MatchClause>();
    private final List<StartClause> startClauses = new ArrayList<StartClause>();
    private final List<WhereClause> whereClauses = new ArrayList<WhereClause>();
    private Sort defaultSorts;
    private int index = 0;
    private final Neo4jPersistentEntity<?> entity;
    private final Neo4jTemplate template;

    public CypherQuery(Neo4jPersistentEntity<?> entity, Neo4jTemplate template) {
        this.entity = entity;
        this.template = template;
    }

    private String getEntityName(Neo4jPersistentEntity<?> entity) {
        return this.variableContext.getVariableFor(entity);
    }

    private String defaultStartClause(Neo4jPersistentEntity<?> entity) {
        return String.format("`%s`=node:__types__(className=\"%s\")", this.getEntityName(entity), entity.getEntityType().getAlias());
    }

    public void addPart(Part part, PersistentPropertyPath<Neo4jPersistentProperty> path) {
        String variable = this.variableContext.getVariableFor(path);
        PartInfo partInfo = new PartInfo(path, variable, part, this.index);
        Neo4jPersistentProperty leafProperty = partInfo.getLeafProperty();
        if (partInfo.isPrimitiveProperty() && !leafProperty.isIdProperty()) {
            if (!this.addedStartClause(partInfo)) {
                this.whereClauses.add(new WhereClause(partInfo, this.template));
            }
        } else if (leafProperty.isEntity()) {
            this.startClauses.add(new NodeEntityMatchingStartClause(partInfo));
            this.whereClauses.add(new TypeRestrictingWhereClause(new PartInfo(path, this.variableContext.getVariableFor(this.entity), part, -1), this.entity, this.template));
        } else if (leafProperty.isIdProperty()) {
            this.startClauses.add(new NodeEntityMatchingStartClause(partInfo));
            this.whereClauses.add(new TypeRestrictingWhereClause(new PartInfo(path, this.variableContext.getVariableFor(this.entity), part, -1), this.entity, this.template));
        } else {
            throw new IllegalStateException("Error " + part + " points neither to a primitive nor a entity property of " + this.entity);
        }
        ++this.index;
        MatchClause matchClause = new MatchClause(path);
        if (matchClause.hasRelationship()) {
            this.matchClauses.add(matchClause);
        }
    }

    public CypherQueryDefinition withSort(Sort sorts) {
        this.defaultSorts = sorts;
        return this;
    }

    private boolean addedStartClause(PartInfo partInfo) {
        if (!partInfo.isIndexed()) {
            return false;
        }
        for (StartClause startClause : this.startClauses) {
            if (!startClause.sameIdentifier(partInfo)) continue;
            if (startClause.sameIndex(partInfo)) {
                startClause.merge(partInfo);
                return true;
            }
            return false;
        }
        this.startClauses.add(new StartClause(partInfo));
        return true;
    }

    public PartInfo getPartInfo(int parameterIndex) {
        for (StartClause startClause : this.startClauses) {
            if (startClause.getPartInfo().getParameterIndex() != parameterIndex) continue;
            return startClause.getPartInfo();
        }
        for (WhereClause whereClause : this.whereClauses) {
            if (whereClause.getPartInfo().getParameterIndex() != parameterIndex) continue;
            return whereClause.getPartInfo();
        }
        throw new IllegalArgumentException("Index " + parameterIndex + " not valid");
    }

    @Override
    public Map<Parameter, Object> resolveParameters(Map<Parameter, Object> parameters) {
        for (StartClause startClause : this.startClauses) {
            parameters = startClause.resolveParameters(parameters, this.template);
        }
        for (MatchClause matchClause : this.matchClauses) {
            parameters = matchClause.resolveParameters(parameters);
        }
        for (WhereClause whereClause : this.whereClauses) {
            parameters = whereClause.resolveParameters(parameters);
        }
        return parameters;
    }

    @Override
    public String toQueryString() {
        return this.toQueryString(this.defaultSorts);
    }

    private String render() {
        String startClauses = StringUtils.collectionToDelimitedString(this.startClauses, (String)", ");
        String matchClauses = this.toQueryString(this.matchClauses);
        String whereClauses = StringUtils.collectionToDelimitedString(this.whereClauses, (String)" AND ");
        StringBuilder builder = new StringBuilder("START ");
        if (StringUtils.hasText((String)startClauses)) {
            builder.append(startClauses);
        } else {
            builder.append(this.defaultStartClause(this.entity));
        }
        if (StringUtils.hasText((String)matchClauses)) {
            builder.append(" MATCH ").append(matchClauses);
        }
        if (StringUtils.hasText((String)whereClauses)) {
            builder.append(" WHERE ").append(whereClauses);
        }
        builder.append(" RETURN ").append(String.format("`%s`", this.getEntityName(this.entity)));
        return builder.toString();
    }

    private String addSorts(Sort sort) {
        List<String> sorts = this.formatSorts(sort);
        return !sorts.isEmpty() ? String.format(" ORDER BY %s", StringUtils.collectionToCommaDelimitedString(sorts)) : "";
    }

    private List<String> formatSorts(Sort sort) {
        ArrayList<String> result = new ArrayList<String>();
        if (sort == null) {
            return result;
        }
        for (Sort.Order order : sort) {
            result.add(String.format("%s %s", order.getProperty(), order.getDirection()));
        }
        return result;
    }

    private String toQueryString(List<MatchClause> matchClauses) {
        ArrayList<String> result = new ArrayList<String>(matchClauses.size());
        for (MatchClause matchClause : matchClauses) {
            result.add(matchClause.toString(this.variableContext));
        }
        return StringUtils.collectionToDelimitedString(result, (String)", ");
    }

    @Override
    public String toQueryString(Sort sort) {
        StringBuilder builder = new StringBuilder(this.render());
        if (sort != null) {
            builder.append(this.addSorts(sort));
        }
        return builder.toString();
    }

    @Override
    public String toQueryString(Pageable pageable) {
        if (pageable == null) {
            return this.render();
        }
        StringBuilder builder = new StringBuilder(this.toQueryString(pageable.getSort()));
        builder.append(String.format(" SKIP %d LIMIT %d", pageable.getOffset(), pageable.getPageSize()));
        return builder.toString();
    }

    public String toString() {
        return this.toQueryString();
    }
}

