/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.relationship;

import org.neo4j.graphdb.Relationship;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.DetachedEntityState;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.node.EntityStateFactory;
import org.springframework.data.neo4j.support.relationship.RelationshipEntityState;

public class RelationshipEntityStateFactory
implements EntityStateFactory<Relationship> {
    private Neo4jTemplate template;
    private DelegatingFieldAccessorFactory relationshipDelegatingFieldAccessorFactory;
    private Neo4jMappingContext mappingContext;

    @Override
    public EntityState<Relationship> getEntityState(Object entity, boolean detachable) {
        Class<?> entityType = entity.getClass();
        Neo4jPersistentEntity persistentEntity = (Neo4jPersistentEntity)this.mappingContext.getPersistentEntity(entityType);
        RelationshipEntityState relationshipEntityState = new RelationshipEntityState(null, entity, entityType, this.template, this.relationshipDelegatingFieldAccessorFactory, persistentEntity);
        if (!detachable) {
            return relationshipEntityState;
        }
        return new DetachedEntityState<Relationship>(relationshipEntityState, this.template);
    }

    public void setTemplate(Neo4jTemplate template) {
        this.template = template;
    }

    public void setRelationshipDelegatingFieldAccessorFactory(DelegatingFieldAccessorFactory delegatingFieldAccessorFactory) {
        this.relationshipDelegatingFieldAccessorFactory = delegatingFieldAccessorFactory;
    }

    public void setMappingContext(Neo4jMappingContext mappingContext) {
        this.mappingContext = mappingContext;
    }

    @Override
    public Neo4jTemplate getTemplate() {
        return this.template;
    }
}

