/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.CypherGraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.CypherQueryCreator;
import org.springframework.data.neo4j.repository.query.CypherQueryDefinition;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public class DerivedCypherRepositoryQuery
extends CypherGraphRepositoryQuery {
    private final CypherQueryDefinition query;

    public DerivedCypherRepositoryQuery(Neo4jMappingContext mappingContext, GraphQueryMethod queryMethod, Neo4jTemplate template) {
        super(queryMethod, template);
        Assert.notNull((Object)((Object)mappingContext));
        EntityMetadata info = queryMethod.getEntityInformation();
        PartTree tree = new PartTree(queryMethod.getName(), info.getJavaType());
        this.query = (CypherQueryDefinition)new CypherQueryCreator(tree, (MappingContext<? extends Neo4jPersistentEntity<?>, Neo4jPersistentProperty>)mappingContext, info.getJavaType()).createQuery();
    }

    @Override
    public Object resolveParameter(Object value, String parameterName, int index) {
        Object newValue = super.resolveParameter(value, parameterName, index);
        PartInfo info = this.query.getPartInfo(index);
        if (info.isFullText()) {
            return String.format("%s:%s", info.getIndexKey(), newValue);
        }
        return newValue;
    }

    @Override
    protected String createQueryWithPagingAndSorting(ParameterAccessor accessor) {
        if (accessor.getPageable() != null) {
            return this.query.toString(accessor.getPageable());
        }
        if (accessor.getSort() != null) {
            return this.query.toString(accessor.getSort());
        }
        return ((Object)this.query).toString();
    }
}

