/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Iterator;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.CypherQueryBuilder;
import org.springframework.data.neo4j.repository.query.CypherQueryDefinition;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

class CypherQueryCreator
extends AbstractQueryCreator<CypherQueryDefinition, CypherQueryBuilder> {
    private final MappingContext<? extends Neo4jPersistentEntity<?>, Neo4jPersistentProperty> context;
    private final Class<?> domainClass;

    public CypherQueryCreator(PartTree tree, MappingContext<? extends Neo4jPersistentEntity<?>, Neo4jPersistentProperty> context, Class<?> domainClass) {
        super(tree);
        Assert.notNull(context);
        Assert.notNull(domainClass);
        this.context = context;
        this.domainClass = domainClass;
    }

    protected CypherQueryBuilder create(Part part, Iterator<Object> iterator) {
        CypherQueryBuilder builder = new CypherQueryBuilder(this.context, this.domainClass);
        builder.addRestriction(part);
        return builder;
    }

    protected CypherQueryBuilder and(Part part, CypherQueryBuilder base, Iterator<Object> iterator) {
        return base.addRestriction(part);
    }

    protected CypherQueryBuilder or(CypherQueryBuilder base, CypherQueryBuilder criteria) {
        throw new UnsupportedOperationException("Or is not supported currently!");
    }

    protected CypherQueryDefinition complete(CypherQueryBuilder criteria, Sort sort) {
        return criteria;
    }
}

