/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import org.springframework.data.neo4j.annotation.Indexed;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.index.IndexType;

public class IndexInfo {
    private String indexName;
    private IndexType indexType;
    private final String fieldName;
    private final Indexed.Level level;
    private String indexKey;

    public IndexInfo(Indexed annotation, Neo4jPersistentProperty property) {
        this.indexName = this.determineIndexName(annotation, property);
        this.indexType = annotation.indexType();
        this.fieldName = annotation.fieldName();
        this.indexKey = this.fieldName.isEmpty() ? property.getNeo4jPropertyName() : this.fieldName;
        this.level = annotation.level();
    }

    private String determineIndexName(Indexed annotation, Neo4jPersistentProperty property) {
        String providedIndexName = annotation.indexName().isEmpty() ? null : annotation.indexName();
        Class<?> declaringClass = property.getField().getDeclaringClass();
        Class instanceType = property.getOwner().getType();
        return Indexed.Name.get(annotation.level(), declaringClass, providedIndexName, instanceType);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public boolean isFullText() {
        return this.indexType == IndexType.FULLTEXT;
    }

    public String getIndexKey() {
        return this.indexKey;
    }
}

